/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public final class Timestamps {
    static final long TIMESTAMP_SECONDS_MIN = -62135596800L;
    static final long TIMESTAMP_SECONDS_MAX = 253402300799L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MILLISECOND = 1000000L;
    static final long NANOS_PER_MICROSECOND = 1000L;
    static final long MILLIS_PER_SECOND = 1000L;
    static final long MICROS_PER_SECOND = 1000000L;
    public static final Timestamp MIN_VALUE = Timestamp.newBuilder().setSeconds(-62135596800L).setNanos(0).build();
    public static final Timestamp MAX_VALUE = Timestamp.newBuilder().setSeconds(253402300799L).setNanos(999999999).build();
    private static final ThreadLocal<SimpleDateFormat> timestampFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return Timestamps.createTimestampFormat();
        }
    };
    private static final Comparator<Timestamp> COMPARATOR = new Comparator<Timestamp>(){

        @Override
        public int compare(Timestamp timestamp, Timestamp timestamp2) {
            Timestamps.checkValid(timestamp);
            Timestamps.checkValid(timestamp2);
            int n = Long.compare(timestamp.getSeconds(), timestamp2.getSeconds());
            return n != 0 ? n : Integer.compare(timestamp.getNanos(), timestamp2.getNanos());
        }
    };

    private static SimpleDateFormat createTimestampFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        simpleDateFormat.setCalendar(gregorianCalendar);
        return simpleDateFormat;
    }

    private Timestamps() {
    }

    public static Comparator<Timestamp> comparator() {
        return COMPARATOR;
    }

    public static int compare(Timestamp timestamp, Timestamp timestamp2) {
        return COMPARATOR.compare(timestamp, timestamp2);
    }

    public static boolean isValid(Timestamp timestamp) {
        return Timestamps.isValid(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static boolean isValid(long l, int n) {
        if (l < -62135596800L || l > 253402300799L) {
            return false;
        }
        return n >= 0 && (long)n < 1000000000L;
    }

    public static Timestamp checkValid(Timestamp timestamp) {
        int n;
        long l = timestamp.getSeconds();
        if (!Timestamps.isValid(l, n = timestamp.getNanos())) {
            throw new IllegalArgumentException(String.format("Timestamp is not valid. See proto definition for valid values. Seconds (%s) must be in range [-62,135,596,800, +253,402,300,799]. Nanos (%s) must be in range [0, +999,999,999].", l, n));
        }
        return timestamp;
    }

    public static String toString(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        long l = timestamp.getSeconds();
        int n = timestamp.getNanos();
        StringBuilder stringBuilder = new StringBuilder();
        Date date = new Date(l * 1000L);
        stringBuilder.append(timestampFormat.get().format(date));
        if (n != 0) {
            stringBuilder.append(".");
            stringBuilder.append(Timestamps.formatNanos(n));
        }
        stringBuilder.append("Z");
        return stringBuilder.toString();
    }

    public static Timestamp parse(String string) throws ParseException {
        int n;
        String string2;
        int n2 = string.indexOf(84);
        if (n2 == -1) {
            throw new ParseException("Failed to parse timestamp: invalid timestamp \"" + string + "\"", 0);
        }
        int n3 = string.indexOf(90, n2);
        if (n3 == -1) {
            n3 = string.indexOf(43, n2);
        }
        if (n3 == -1) {
            n3 = string.indexOf(45, n2);
        }
        if (n3 == -1) {
            throw new ParseException("Failed to parse timestamp: missing valid timezone offset.", 0);
        }
        String string3 = string2 = string.substring(0, n3);
        String string4 = "";
        int n4 = string2.indexOf(46);
        if (n4 != -1) {
            string3 = string2.substring(0, n4);
            string4 = string2.substring(n4 + 1);
        }
        Date date = timestampFormat.get().parse(string3);
        long l = date.getTime() / 1000L;
        int n5 = n = string4.isEmpty() ? 0 : Timestamps.parseNanos(string4);
        if (string.charAt(n3) == 'Z') {
            if (string.length() != n3 + 1) {
                throw new ParseException("Failed to parse timestamp: invalid trailing data \"" + string.substring(n3) + "\"", 0);
            }
        } else {
            String string5 = string.substring(n3 + 1);
            long l2 = Timestamps.parseTimezoneOffset(string5);
            l = string.charAt(n3) == '+' ? (l -= l2) : (l += l2);
        }
        try {
            return Timestamps.normalizedTimestamp(l, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Failed to parse timestamp: timestamp is out of range.", 0);
        }
    }

    public static Timestamp fromSeconds(long l) {
        return Timestamps.normalizedTimestamp(l, 0);
    }

    public static long toSeconds(Timestamp timestamp) {
        return Timestamps.checkValid(timestamp).getSeconds();
    }

    public static Timestamp fromMillis(long l) {
        return Timestamps.normalizedTimestamp(l / 1000L, (int)(l % 1000L * 1000000L));
    }

    public static long toMillis(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        return LongMath.checkedAdd((long)LongMath.checkedMultiply((long)timestamp.getSeconds(), (long)1000L), (long)((long)timestamp.getNanos() / 1000000L));
    }

    public static Timestamp fromMicros(long l) {
        return Timestamps.normalizedTimestamp(l / 1000000L, (int)(l % 1000000L * 1000L));
    }

    public static long toMicros(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        return LongMath.checkedAdd((long)LongMath.checkedMultiply((long)timestamp.getSeconds(), (long)1000000L), (long)((long)timestamp.getNanos() / 1000L));
    }

    public static Timestamp fromNanos(long l) {
        return Timestamps.normalizedTimestamp(l / 1000000000L, (int)(l % 1000000000L));
    }

    public static long toNanos(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        return LongMath.checkedAdd((long)LongMath.checkedMultiply((long)timestamp.getSeconds(), (long)1000000000L), (long)timestamp.getNanos());
    }

    public static Duration between(Timestamp timestamp, Timestamp timestamp2) {
        Timestamps.checkValid(timestamp);
        Timestamps.checkValid(timestamp2);
        return Durations.normalizedDuration(LongMath.checkedSubtract((long)timestamp2.getSeconds(), (long)timestamp.getSeconds()), IntMath.checkedSubtract((int)timestamp2.getNanos(), (int)timestamp.getNanos()));
    }

    public static Timestamp add(Timestamp timestamp, Duration duration) {
        Timestamps.checkValid(timestamp);
        Durations.checkValid(duration);
        return Timestamps.normalizedTimestamp(LongMath.checkedAdd((long)timestamp.getSeconds(), (long)duration.getSeconds()), IntMath.checkedAdd((int)timestamp.getNanos(), (int)duration.getNanos()));
    }

    public static Timestamp subtract(Timestamp timestamp, Duration duration) {
        Timestamps.checkValid(timestamp);
        Durations.checkValid(duration);
        return Timestamps.normalizedTimestamp(LongMath.checkedSubtract((long)timestamp.getSeconds(), (long)duration.getSeconds()), IntMath.checkedSubtract((int)timestamp.getNanos(), (int)duration.getNanos()));
    }

    static Timestamp normalizedTimestamp(long l, int n) {
        if ((long)n <= -1000000000L || (long)n >= 1000000000L) {
            l = LongMath.checkedAdd((long)l, (long)((long)n / 1000000000L));
            n = (int)((long)n % 1000000000L);
        }
        if (n < 0) {
            n = (int)((long)n + 1000000000L);
            l = LongMath.checkedSubtract((long)l, (long)1L);
        }
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(l).setNanos(n).build();
        return Timestamps.checkValid(timestamp);
    }

    private static long parseTimezoneOffset(String string) throws ParseException {
        int n = string.indexOf(58);
        if (n == -1) {
            throw new ParseException("Invalid offset value: " + string, 0);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return (Long.parseLong(string2) * 60L + Long.parseLong(string3)) * 60L;
    }

    static int parseNanos(String string) throws ParseException {
        int n = 0;
        for (int i = 0; i < 9; ++i) {
            n *= 10;
            if (i >= string.length()) continue;
            if (string.charAt(i) < '0' || string.charAt(i) > '9') {
                throw new ParseException("Invalid nanoseconds.", 0);
            }
            n += string.charAt(i) - 48;
        }
        return n;
    }

    static String formatNanos(int n) {
        if ((long)n % 1000000L == 0L) {
            return String.format(Locale.ENGLISH, "%1$03d", (long)n / 1000000L);
        }
        if ((long)n % 1000L == 0L) {
            return String.format(Locale.ENGLISH, "%1$06d", (long)n / 1000L);
        }
        return String.format(Locale.ENGLISH, "%1$09d", n);
    }
}

