# How to Contribute / 如何贡献代码

[English](#English)  
[简体中文](#简体中文)

## English

### Pull Requests

1. Fork the this repository
2. Create a new branch for each feature or improvement
3. Send a pull request from each feature branch against the dev branch.

It is very important to separate new features or improvements into separate feature branches, and to send a
pull request for each branch. This allows each feature or improvement to be reviewed and merged individually.

### Coding Style

All pull requests and commits **must** adhere to the [PSR-2 standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md) at least.
And we **recommend** adhering to the [PSR-12 standard](https://github.com/php-fig/fig-standards/blob/master/proposed/extended-coding-style-guide.md).

### Commit message

The Commit message **must** containe all the changes you maked in sort.
Please **do not** use words like "fix", "improve" only.

## 简体中文

### Pull Request

1. Fork 本项目
2. 为每一项新特性或改进创建一个新的分支
3. 为每一项新特性或改进创建一个独立的 Pull Request 至 dev 分支

我们建议你将不同的新特性置于不同的分支并以不同的 Pull Request 提交，这将有利于我们独立审查代码并独立合并。

### 代码风格

所有的 Pull request 和 commit 都至少**必须**遵守 [PSR-2 标准](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)。
我们建议**最好**遵守 [PSR-12 标准](https://github.com/php-fig/fig-standards/blob/master/proposed/extended-coding-style-guide.md)。

### Commit 消息

Commit 消息必须简洁地包含你所有的修改。请不要仅使用「修复」、「改进」等字样。
