package io.quarkus.it.kafka.streams;

import static io.strimzi.test.container.StrimziKafkaContainer.KAFKA_PORT;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.testcontainers.utility.MountableFile;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.strimzi.test.container.StrimziKafkaContainer;

public class KafkaSSLTestResource implements QuarkusTestResourceLifecycleManager {

    private static final StrimziKafkaContainer kafka = new StrimziKafkaContainer()
            .withServerProperties(MountableFile.forClasspathResource("server.properties"))
            .withBootstrapServers(c -> String.format("SSL://%s:%s", c.getContainerIpAddress(), c.getMappedPort(KAFKA_PORT)))
            .withCopyFileToContainer(MountableFile.forClasspathResource("ks-keystore.p12"),
                    "/opt/kafka/config/kafka-keystore.p12")
            .withCopyFileToContainer(MountableFile.forClasspathResource("ks-truststore.p12"),
                    "/opt/kafka/config/kafka-truststore.p12");

    public static String getBootstrapServers() {
        return kafka.getBootstrapServers();
    }

    @Override
    public Map<String, String> start() {
        kafka.start();
        // Used by the application
        Map<String, String> properties = new HashMap<>();
        properties.put("kafka.bootstrap.servers", kafka.getBootstrapServers());
        properties.put("ssl-dir", new File("src/main/resources").getAbsolutePath());

        return properties;
    }

    @Override
    public void stop() {
        if (kafka != null) {
            kafka.close();
        }
        System.clearProperty("boostrap.servers");
    }

}
