<!--
SPDX-FileCopyrightText: 2023 Roman Gilg <subdiff@gmail.com>

SPDX-License-Identifier: GPL-2.0-or-later
-->

DESCRIPTION OF AURORAE
======================

Aurorae is a theme engine for KWin window decorations. It is built against the unstable API of KWin
in KDE 4.3. Aurorae uses SVG to render the decoration and buttons and there is a simple config file
for configuring the theme details.

This theme engine uses Plasma technologie to render the window decoration. Every detail can be
themed by the usage of SVG. The theme engine uses Plasma's FrameSvg, so you can provide SVG files
containing borders. This is described in more detail in techbase:
https://develop.kde.org/docs/extend/plasma/theme/theme-details/

The theme consists of one folder containing svgz files for decoration and buttons, one KConfig file
for the theme details and one metadata.desktop file which you can use to name your theme, author
information, etc.

Although the engine uses Plasma technology, it isn't Plasma. So it does not know anything about
Plasmoids and you will never be able to put Plasmoids into the decoration. That is out of scope of
this engine.

Aurorae uses the features provided by KWin 4.3. So the themes can provide their own decoration
shadows and it is recommended that your themes provide those. The engine supports ARGB decoration
which is enabled by default. If you provide a theme using translucency, please make sure, that it
works without compositing as well.

Window Decoration
=================
The window decoration has to be provided in file "decoration.svgz". This svg has to contain all the
elements required for a Plasma theme background. The decoration has to use the element prefix
"decoration".

If you want to provide a different style for inactive windows you can add it to the same svg. The
inactive elements must have the element prefix "decoration-inactive". The theme engine tests for
this prefix and if not provided inactive windows will be rendered with the same style as active
windows.

You have to provide a special decoration for opaque mode, that is when compositing is not active.
The element prefix is "decoration-opaque" for active and "decoration-opaque-inactive" for
inactive windows.

If you want to provide a mask for your decoration, you can include an element "mask"
inside "decoration.svgz" file. That element will be used to specify the blur region
of your decoration.

Maximized Windows
-----------------
In order to better support maximized windows there exists a special frame svg called
"decoration-maximized". In the same way as for the general decoration you can specify a version for
inactive, opaque and inactive-opaque. This results in the following names:
 * decoration-maximized
 * decoration-maximized-inactive
 * decoration-maximized-opaque
 * decoration-maximized-opaque-inactive

In all cases only the center element will be used. There is no need to specify borders. Please note
that in case of a window with translucent widgets the center element will be stretched to the size
of the complete window.

The following fallback strategy is used: if inactive is not present it falls back to the active.
If opaque is not present it falls back to the translucent. If none of the maximized elements are
present the center element of the decoration is used!

In order to support Fitts' Law all TitleEdge Settings are set to 0. So the buttons will be directly
next to the screen edges. You have the possibility to overwrite these settins (see below).

Buttons
=======
You have to provide a svgz file for each button your theme should contain. If you do not provide a
file for a button type the engine will not include that button, so your decoration will miss it.
There is no fallback to a default theme. The buttons are rendered using Plasma's FrameSvg as well.
So you have to provide the "center" element. Borders are not supported

You can provide the following buttons:
 * close
 * minimize
 * maximize
 * restore
 * alldesktops
 * keepabove
 * keepbelow
 * shade
 * resize
 * help

Each button can have different states. So a button could be hovered, pressed, deactivated and you
might want to provide different styles for active and inactive windows. You can use the following
element prefix to provide styles for the buttons:
 * active (normal button for active window)
 * inactive (normal button for inactive window)
 * hover (hover state for active window)
 * hover-inactive (hover state for inactive window)
 * pressed (button is pressed)
 * pressed-inactive (pressed inactive button)
 * deactivated (button cannot be clicked, e.g. window cannot be closed)
 * deactivated-inactive (same for inactive windows)

You have at least to provide the active element. All other elements are optional and the active
element is always used as a fallback. If you provide the inactive element, this is used as a
fallback for the inactive window. That is, if you provide a hover element, but none for inactive,
the inactive window will not have a hover effect. Same is true for pressed and deactivated.
Reasonable that means if you provide a deactivated and an inactive element you want to provide a
deactivated-inactive element as well.

Configuration file
==================
The configuration file is a normal KConfig file. You have to give it the name of your decoration
with suffix "rc". So if your theme has the name "deco", your config file will be named "decorc".
The following section shows the possible options with their default values.

[General]
TitleAlignment=Left             # vorizontal alignment of window title
TitleVerticalAlignment=Center   # vertical alignment of window title
Animation=0                     # animation duration in msec when hovering a button and on active/inactive change
ActiveTextColor=0,0,0,255       # title text color of active window
InactiveTextColor=0,0,0,255     # title text color of inactive window
UseTextShadow=false             # Draw Shadow behind title text
ActiveTextShadowColor=255,255,255,255 # Shadow text color of active window
InactiveTextShadowColor=255,255,255,255 # Shadow text color of active window
TextShadowOffsetX=0             # Offset of shadow in x direction
TextShadowOffsetY=0             # Offset of shadow in y direction
HaloActive=false                # Draw halo behing title of active window (since 4.5)
HaloInactive=false              # Draw halo behing title of inactive window (since 4.5)
LeftButtons=MS                  # buttons in left button group (see http://api.kde.org/4.x-api/kdebase-workspace-apidocs/kwin/lib/html/classKDecorationOptions.html#8ad12d76c93c5f1a12ea07b30f92d2fa)
RightButtons=HIA__X             # buttons in right button group
Shadow=true                     # decoration provides shadows: you have to add padding

[Layout]                        # uses Layout Manager (see http://api.kde.org/4.x-api/kdebase-workspace-apidocs/kwin/lib/html/classKCommonDecoration.html#7932f74c28432ad8de232f1c6e8751ce)
BorderLeft=5
BorderRight=5
BorderBottom=5
TitleEdgeTop=5
TitleEdgeBottom=5
TitleEdgeLeft=5
TitleEdgeRight=5
TitleEdgeTopMaximized=0
TitleEdgeBottomMaximized=0
TitleEdgeLeftMaximized=0
TitleEdgeRightMaximized=0
TitleBorderLeft=5
TitleBorderRight=5
TitleHeight=20
ButtonWidth=20
ButtonWidthMinimize=?           # optional - default depends on ButtonWidth
ButtonWidthMaximizeRestore=?    # optional - default depends on ButtonWidth
ButtonWidthClose=?              # optional - default depends on ButtonWidth
ButtonWidthAlldesktops=?        # optional - default depends on ButtonWidth
ButtonWidthKeepabove=?          # optional - default depends on ButtonWidth
ButtonWidthKeepbelow=?          # optional - default depends on ButtonWidth
ButtonWidthShade=?              # optional - default depends on ButtonWidth
ButtonWidthHelp=?               # optional - default depends on ButtonWidth
ButtonWidthMenu=?               # optional - default depends on ButtonWidth
ButtonHeight=20
ButtonSpacing=5
ButtonMarginTop=0
ExplicitButtonSpacer=10
PaddingTop=0                    # Padding added to provide shadows
PaddingBottom=0                 # Padding added to provide shadows
PaddingRight=0                  # Padding added to provide shadows
PaddingLeft=0                   # Padding added to provide shadows

Packaging
=========
All theme files (decoration, buttons, metadata.desktop and configuration file) have to be stored in
one directory with the name of the theme (this has to be identical to the one used for the config
file). You have to create a tar.gz archive from that directory. This archive is the theme, which
can be installed in the kcm for window decorations.
