
module mixin1;

import std.stdio;

/*******************************************/

mixin template Foo(T)
{
    T x;
}

mixin Foo!(uint);

struct Bar
{
    template Abc(T)
    {
	T y;
    }

    template Def(T)
    {
	T z;
    }
}

mixin Bar.Abc!(int);

Bar b;
mixin typeof(b).Def!(int);

void test1()
{
    x = 3;
    assert(x == 3);
    y = 4;
    assert(y == 4);
    z = 5;
    assert(z == 5);
}

/*******************************************/

template Foo2(T)
{
    T x2 = T.sizeof;
}

mixin Foo2!(uint) B2;
mixin Foo2!(long) C2;
mixin Foo2!(int);

void test2()
{
    B2.x2 = 3;
    assert(B2.x2 == 3);
    assert(C2.x2 == long.sizeof);
//    assert(x2 == int.sizeof);
}

/*******************************************/

template Foo3(T)
{
    int func() { printf("Foo3.func()\n"); return 1; }
}

class Bar3
{
    mixin Foo3!(int);
}

class Code3 : Bar3
{
    int func() { printf("Code3.func()\n"); return 2; }
}

void test3()
{
    int i;

    Bar3 b = new Bar3();
    i = b.func();
    assert(i == 1);

    b = new Code3();
    i = b.func();
    assert(i == 2);
}

/*******************************************/

template Foo4(T)
{
    int func() { printf("Foo4.func()\n"); return 1; }
}

struct Bar4
{
    mixin Foo4!(int);
}

void test4()
{
    int i;

    Bar4 b;
    i = b.func();
    assert(i == 1);
}

/*******************************************/

template Foo5()
{
    int func() { printf("Foo5.func()\n"); return 1; }
}

struct Bar5
{
    mixin Foo5;
}

void test5()
{
    int i;

    Bar5 b;
    i = b.func();
    assert(i == 1);
}

/*******************************************/

template Foo6()
{
    int x = 5;
}

struct Bar6
{
    mixin Foo6;
}

void test6()
{
    int i;

    Bar6 b;
    i = b.x;
    assert(i == 5);
    assert(b.sizeof == int.sizeof);
}

/*******************************************/

template Foo7()
{
    int x = 5;
}

class Bar7
{
    int y = 6;
    mixin Foo7;
}

void test7()
{
    int i;

    Bar7 b = new Bar7();
    i = b.x;
    printf("b.x = %d\n", b.x);
    assert(i == 5);
}

/*******************************************/

template Foo8()
{
    int x = 5;
    int bar() { return 7; }
}

void test8()
{
    mixin Foo8;
    printf("x = %d\n", x);
    assert(x == 5);
    assert(bar() == 7);
}

/*******************************************/

template Foo9()
{
    int abc() { return y; }
}

void test9()
{
    int y = 8;
    mixin Foo9;
    assert(abc() == 8);
}

/*******************************************/

template Foo10(alias b)
{
    typeof(b) abc() { return b; }
}

void test10()
{
    int y = 8;
    mixin Foo10!(y);
    assert(abc() == 8);
}


/*******************************************/

template Foo11(alias b)
{
    int abc() { return b; }
}

void test11()
{
    int y = 8;
    mixin Foo11!(y) B;
    assert(B.abc() == 8);
}

/*******************************************/

template duff_for(alias id1, alias id2, alias s)
{

    void duff_for()
    {
	printf("duff_for(%d, %d)\n", id1, id2);
	typeof(id1) id = id1;
        printf("fid = %d, %d\n", id, (id2 - id) % 8);
        switch ((id2 - id) % 8)
        {
        case 0:
	 while (id != id2)
	 {
	     printf("wid = %d\n", id);
	     s(); ++id;
        case 7: s(); ++id;
        case 6: s(); ++id;
        case 5: s(); ++id;
        case 4: s(); ++id;
        case 3: s(); ++id;
        case 2: s(); ++id;
        case 1: s(); ++id;
	 }
        }
    }
}

void foo12() { printf("foo12\n"); }

void test12()
{
    int i = 1;
    int j = 11;

    mixin duff_for!(i, j, delegate void() { foo12(); });
    duff_for();
}

/*******************************************/

template duff(alias id1, alias id2, alias s)
{

    void duff()
    {
	s();
	s();
    }
}

void foo13(int j)
{
    printf("foo13 j = %d\n", j);
    assert(j == 1);
}

void test13()
{
    int i = 1;
    int j = 11;

    mixin duff!(i, j, delegate { foo13(i); });
    duff();
}

/*******************************************/

template Foo14()
{
    int x14 = 5;
}

void test14()
{
    int x14 = 6;
    mixin Foo14;
    printf("x14 = %d\n", x14);
    assert(x14 == 6);
}

/*******************************************/

template Foo15()
{
    int x15 = 5;

    int bar15() { return x15; }
}

int x15 = 6;
mixin Foo15;

void test15()
{

    printf("x15 = %d\n", x15);
    printf("bar15() = %d\n", bar15());
    assert(x15 == 6);
    assert(bar15() == 5);
}

/*******************************************/

template Foo16()
{
    int x16 = 5;

    int bar() { return x16; }
}

mixin Foo16 A16;
int x16 = 6;
mixin Foo16 B16;

void test16()
{

    printf("x16 = %d\n", x16);
    printf("bar() = %d\n", A16.bar());
    assert(x16 == 6);
    assert(A16.x16 == 5);
    assert(B16.x16 == 5);
    assert(A16.bar() == 5);
    assert(B16.bar() == 5);
}

/*******************************************/

template Foo17()
{
    int x17 = 5;
}

mixin Foo17;

struct Bar17
{
    mixin Foo17;
}

void test17()
{
    printf("x17 = %d\n", x17);		// prints 5
    assert(x17 == 5);
    {   Bar17 b;
	int x17 = 3;

	printf("b.x17 = %d\n", b.x17);	// prints 5
	assert(b.x17 == 5);
	printf("x17 = %d\n", x17);	// prints 3
	assert(x17 == 3);
	{
	    mixin Foo17;
	    printf("x17 = %d\n", x17);	// prints 5
	    assert(x17 == 5);
	    x17 = 4;
	    printf("x17 = %d\n", x17);	// prints 4
	    assert(x17 == 4);
	}
	printf("x17 = %d\n", x17);	// prints 3
	assert(x17 == 3);
    }
    printf("x17 = %d\n", x17);		// prints 5
    assert(x17 == 5);
}
	
/*******************************************/

template Foo18() { int z = 3; }

struct Bar18(alias Tmpl)
{
    mixin Tmpl;
}

Bar18!(Foo18) b18;

void test18()
{
    assert(b18.z == 3);
}

/*******************************************/

template Mix1(T)
{
    int foo19(T a) { return 2*a; }
}

template Mix2(T)
{
    mixin Mix1!(T);

    int bar19(T a) { return foo19(a); }
}

mixin Mix2!(int);

void test19()
{
    int i;

    i = bar19(7);
    assert(i == 14);
}

/*******************************************/

interface A20 { int f(); }

template Foo20()
{
    int f()
    {
	printf("in C20.f()\n");
	return 6;
    }
}

class C20 : A20
{
    mixin Foo20;
//    void f() { printf("in C20.f()\n"); }
}

void test20()
{
    C20 c = new C20();
    int i = c.f();
    assert(i == 6);
}

/*******************************************/

template Mix21() { this(int x) { printf("mix1\n"); }}

class Bar21
{
     int myx;
     mixin Mix21; // wouldn't compile

     this() { myx = 15; }

//     mixin Mix21; // placing it here compiles
}

void test21()
{
     Bar21 bar = new Bar21();
}

/*******************************************/

template A22(T)
{
    this()
    {	int i;
        i = super.foo();
	assert(i == 67);
    }
}


class B22
{
    int foo() { printf("B22.foo()\n"); return 67; }
}

class C22 : B22
{
    mixin A22!(C22);
}

void test22()
{
    C22 c = new C22;
}


/*******************************************/

template Foo23()
{
     const int x = 5;
}

class C23
{
     mixin Foo23 F;
}

struct D23
{
     mixin Foo23 F;
}

void test23()
{
     C23 c = new C23;

     printf("%d\n",c.F.x);
     assert(c.F.x == 5);

     D23 d;

     printf("%d\n",d.F.x);
     assert(d.F.x == 5);
}

/*******************************************/

template T24()
{
   void foo24() { return cast(void)0; }
   alias foo24 foo24;
}

mixin T24;

void test24()
{
   foo24();
}


/*******************************************/

template ctor25()
{
 this() { this(null); }
 this( Object o ) {}
}

class Foo25
{
 mixin ctor25;
}

void test25()
{
 Foo25 foo = new Foo25();
}


/*******************************************/

template Get26(T)
{
        Reader get (ref T x)
        {
                return this;
        }
}

class Reader
{

        mixin Get26!(byte) bar;
        alias bar.get get;
        mixin Get26!(int) beq;
        alias beq.get get;
}

void test26()
{
        Reader r = new Reader;
	Reader s;
        byte q;
        s = r.get (q);
	assert(s == r);
}

/*******************************************/

template Template(int L)
{
	int i = L;
	int foo(int b = Template!(9).i) {
		return b;
	}
}

void test27()
{
	int i = 10;
	int foo(int b = Template!(9).i) {
		return b;
	}
	assert(foo()==9);
}

/*******************************************/

template Blah28(int a, alias B)
{
   mixin Blah28!(a-1, B);
   //mixin Blah28!(0, B);
}

template Blah28(int a:0, alias B)
{
}

void test28()
{
   int a;
   mixin Blah28!(5,a);
   printf("a = %d\n", a);
}

/*******************************************/

template T29()
{
	int x;
}

struct S29
{
	mixin T29;
	int y;
}

const S29 s29 = { x:2, y:3 };

void test29()
{
	assert(s29.x == 2);
	assert(s29.y == 3);
}

/*******************************************/

class A30
{
        template ctor(Type)
        {
                this(Type[] arr)
                {
                        foreach(Type v; arr) writeln(typeid(typeof(v)));
                }
        }

        mixin ctor!(int);
}

void test30()
{
	static int[] ints = [0,1,2,3];
	A30 a = new A30(ints);
}

/*******************************************/

template Share(T) {
  const bool opEquals(ref const T x) { return true; }
}

struct List31(T) {

    //int opEquals(List31 x) { return 0; }
    mixin Share!(List31);
}

void test31()
{
  List31!(int) x;
  List31!(int) y;
  int i = x == y;
  assert(i == 1);
}

/*******************************************/

template Blah(int a, alias B)
{
   mixin Blah!(a-1, B);
}

template Blah(int a:0, alias B)
{
    int foo()
    {   return B + 1;
    }
}

void test32()
{
   int a = 3;
   mixin Blah!(5,a);

   assert(foo() == 4);
}

/*******************************************/

template T33( int i )
{
    int foo()
    {
        printf("foo %d\n", i );
	return i;
    }
    int opCall()
    {
        printf("opCall %d\n", i );
	return i;
    }
}


class C33
{
    mixin T33!( 1 ) t1;
    mixin T33!( 2 ) t2;
}

void test33()
{
    int i;
    C33 c1 = new C33;
    i = c1.t1.foo();
    assert(i == 1);
    i = c1.t2.foo();
    assert(i == 2);
    i = c1.t1();
    assert(i == 1);
    i = c1.t2();
    assert(i == 2);
}


/*******************************************/

template mix34()
{
    int i;
    void print()
    {
	printf( "%d %d\n", i, j );
	assert(i == 0);
	assert(j == 0);
    }
}

void test34()
{
    int j;
    mixin mix34!();

    print();
    //printf( "%i\n", i );
}

/*******************************************/

mixin T35!(int) m35;

template T35(t)
{
    t a;
}

void test35()
{
   m35.a = 3;
}

/*******************************************/

struct Foo36
{
    int a;
    mixin T!(int) m;
    template T(t)
    {
	t b;
    }
    int c;
}

void test36()
{
   Foo36 f;
   printf("f.sizeof = %d\n", f.sizeof);
   assert(f.sizeof == 12);

   f.a = 1;
   f.m.b = 2;
   f.c = 3;

   assert(f.a == 1);
   assert(f.m.b == 2);
   assert(f.c == 3);
}

/*******************************************/

template Foo37()
{
        template func() {
                int func() {
                        return 6;
                }
        }
}

class Baz37
{
        mixin Foo37 bar;
}

void test37()
{
	Baz37 b = new Baz37;
        auto i = b.bar.func!()();
	assert(i == 6);
        i = (new Baz37).bar.func!()();
	assert(i == 6);
}

/*******************************************/

template Foo38()
{
    int a = 4;

    ~this()
    {
	printf("one\n");
	assert(a == 4);
	assert(b == 5);
	c++;
    }
}

class Outer38
{   int b = 5;

    static int c;

    mixin Foo38!() bar;
    mixin Foo38!() abc;

    ~this()
    {
	printf("two\n");
	assert(b == 5);
	assert(c == 0);
	c++;
    }
}

void test38()
{
    Outer38 o = new Outer38();
    delete o;
    assert(Outer38.c == 3);
}

/*******************************************/

template TDtor()
{
    ~this()
    {
	printf("Mixed-in dtor\n");
    }
}

class Base39
{
    ~this()
    {
	printf("Base39 dtor\n");
    }
}

class Class39 : Base39
{
    mixin TDtor A;
    mixin TDtor B;

    ~this()
    {
	printf("Class39 dtor\n");
    }
}

void test39()
{
    auto test = new Class39;
}


/*******************************************/

template Mix40()
{
  int  i;
}

struct Z40
{
  union { mixin Mix40; }
}

void test40()
{
    Z40 z;
    z.i = 3;
}

/*******************************************/


class X41(P...)
{
    alias P[0] Q;
    mixin Q!();
}

template MYP()
{
    void foo() { }
}

void test41()
{
    X41!(MYP) x;
}

/*******************************************/

int main()
{
    test1();
    test2();
    test3();
    test4();
    test5();
    test6();
    test7();
    test8();
    test9();
    test10();
    test11();
    test12();
    test13();
    test14();
    test15();
    test16();
    test17();
    test18();
    test19();
    test20();
    test21();
    test22();
    test23();
    test24();
    test25();
    test26();
    test27();
    test28();
    test29();
    test30();
    test31();
    test32();
    test33();
    test34();
    test35();
    test36();
    test37();
    test38();
    test39();
    test40();
    test41();

    printf("Success\n");
    return 0;
}
