/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.SimpleRootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.insightech.er.ResourceString;
import org.insightech.er.Resources;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPartFactory;
import org.insightech.er.editor.controller.editpart.element.PagableFreeformRootEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.view.action.dbexport.ExportToImageAction;
import org.insightech.er.util.Format;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.insightech.er";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        Resources.PINK.dispose();
        Resources.ADDED_COLOR.dispose();
        Resources.UPDATED_COLOR.dispose();
        Resources.REMOVED_COLOR.dispose();
        Resources.GRID_COLOR.dispose();
        Resources.DEFAULT_TABLE_COLOR.dispose();
        Resources.SELECTED_REFERENCED_COLUMN.dispose();
        Resources.SELECTED_FOREIGNKEY_COLUMN.dispose();
        Resources.SELECTED_REFERENCED_AND_FOREIGNKEY_COLUMN.dispose();
        Resources.VERY_LIGHT_GRAY.dispose();
        Resources.LINE_COLOR.dispose();
        Resources.TEST_COLOR.dispose();
        Resources.NOT_NULL_COLOR.dispose();
        Resources.PRIMARY_COLOR.dispose();
        Resources.FOREIGN_COLOR.dispose();
        Resources.disposeColorMap();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private static ImageDescriptor loadImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("ALIGN_BOTTOM", Activator.loadImageDescriptor("icons/alignbottom.gif"));
        reg.put("ALIGN_CENTER", Activator.loadImageDescriptor("icons/aligncenter.gif"));
        reg.put("ALIGN_LEFT", Activator.loadImageDescriptor("icons/alignleft.gif"));
        reg.put("ALIGN_MIDDLE", Activator.loadImageDescriptor("icons/alignmid.gif"));
        reg.put("ALIGN_RIGHT", Activator.loadImageDescriptor("icons/alignright.gif"));
        reg.put("ALIGN_TOP", Activator.loadImageDescriptor("icons/aligntop.gif"));
        reg.put("ARROW", Activator.loadImageDescriptor("icons/arrow16.gif"));
        reg.put("CATEGORY", Activator.loadImageDescriptor("icons/category.gif"));
        reg.put("CHANGE_BACKGROUND_COLOR", Activator.loadImageDescriptor("icons/color.gif"));
        reg.put("CHANGE_BACKGROUND_COLOR_DISABLED", Activator.loadImageDescriptor("icons/square.gif"));
        reg.put("CHECK", Activator.loadImageDescriptor("icons/tick.png"));
        reg.put("CHECK_GREY", Activator.loadImageDescriptor("icons/tick_grey.png"));
        reg.put("COMMENT_CONNECTION", Activator.loadImageDescriptor("icons/comment_connection.gif"));
        reg.put("DATABASE", Activator.loadImageDescriptor("icons/database2.png"));
        reg.put("DATABASE_CONNECT", Activator.loadImageDescriptor("icons/database_connect.png"));
        reg.put("DICTIONARY", Activator.loadImageDescriptor("icons/dictionary.gif"));
        reg.put("DICTIONARY_OPEN", Activator.loadImageDescriptor("icons/dictionary_open.gif"));
        reg.put("EDIT", Activator.loadImageDescriptor("icons/pencil.png"));
        reg.put("ERROR", Activator.loadImageDescriptor("icons/error.gif"));
        reg.put("EXPORT_DDL", Activator.loadImageDescriptor("icons/document-attribute-d.png"));
        reg.put("EXPORT_TO_CSV", Activator.loadImageDescriptor("icons/document-excel-csv.png"));
        reg.put("EXPORT_TO_DB", Activator.loadImageDescriptor("icons/database_connect.png"));
        reg.put("EXPORT_TO_EXCEL", Activator.loadImageDescriptor("icons/document-excel.png"));
        reg.put("EXPORT_TO_HTML", Activator.loadImageDescriptor("icons/document-globe.png"));
        reg.put("EXPORT_TO_IMAGE", Activator.loadImageDescriptor("icons/document-image.png"));
        reg.put("EXPORT_TO_JAVA", Activator.loadImageDescriptor("icons/page_white_cup.png"));
        reg.put("EXPORT_TO_TEST_DATA", Activator.loadImageDescriptor("icons/tables--arrow.png"));
        reg.put("FIND", Activator.loadImageDescriptor("icons/binocular.png"));
        reg.put("FOREIGN_KEY", Activator.loadImageDescriptor("icons/foreign_key.gif"));
        reg.put("GRID", Activator.loadImageDescriptor("icons/grid.png"));
        reg.put("GRID_SNAP", Activator.loadImageDescriptor("icons/grid-snap.png"));
        reg.put("GROUP", Activator.loadImageDescriptor("icons/group.gif"));
        reg.put("HORIZONTAL_LINE", Activator.loadImageDescriptor("icons/horizontal_line.gif"));
        reg.put("HORIZONTAL_LINE_DISABLED", Activator.loadImageDescriptor("icons/horizontal_line_disabled.gif"));
        reg.put("IMAGE", Activator.loadImageDescriptor("icons/image--plus.png"));
        reg.put("INDEX", Activator.loadImageDescriptor("icons/index.gif"));
        reg.put("LOCK_EDIT", Activator.loadImageDescriptor("icons/lock--pencil.png"));
        reg.put("MATCH_HEIGHT", Activator.loadImageDescriptor("icons/matchheight.gif"));
        reg.put("MATCH_WIDTH", Activator.loadImageDescriptor("icons/matchwidth.gif"));
        reg.put("NOTE", Activator.loadImageDescriptor("icons/note.gif"));
        reg.put("OPTION", Activator.loadImageDescriptor("icons/wrench.png"));
        reg.put("PAGE_SETTING_H", Activator.loadImageDescriptor("images/h.png"));
        reg.put("PAGE_SETTING_V", Activator.loadImageDescriptor("images/v.png"));
        reg.put("PALETTE", Activator.loadImageDescriptor("icons/palette.png"));
        reg.put("PRIMARY_KEY", Activator.loadImageDescriptor("icons/pkey.gif"));
        reg.put("RELATION_1_N", Activator.loadImageDescriptor("icons/relation_1_n.gif"));
        reg.put("RELATION_N_N", Activator.loadImageDescriptor("icons/relation_n_n.gif"));
        reg.put("RELATION_SELF", Activator.loadImageDescriptor("icons/relation_self.gif"));
        reg.put("RESIZE", Activator.loadImageDescriptor("icons/application-resize-actual.png"));
        reg.put("SEQUENCE", Activator.loadImageDescriptor("icons/sequence.gif"));
        reg.put("TITLEBAR_BACKGROUND", Activator.loadImageDescriptor("images/aqua-bg.gif"));
        reg.put("TABLE", Activator.loadImageDescriptor("icons/table.gif"));
        reg.put("TABLE_NEW", Activator.loadImageDescriptor("icons/table_new.gif"));
        reg.put("TABLESPACE", Activator.loadImageDescriptor("icons/database.png"));
        reg.put("TEST_DATA", Activator.loadImageDescriptor("icons/tables--pencil.png"));
        reg.put("TOOLTIP", Activator.loadImageDescriptor("icons/ui-tooltip.png"));
        reg.put("TRIGGER", Activator.loadImageDescriptor("icons/arrow-turn-000-left.png"));
        reg.put("VERTICAL_LINE", Activator.loadImageDescriptor("icons/vertical_line.gif"));
        reg.put("VERTICAL_LINE_DISABLED", Activator.loadImageDescriptor("icons/vertical_line_disabled.gif"));
        reg.put("VIEW", Activator.loadImageDescriptor("icons/view.gif"));
        reg.put("WORD", Activator.loadImageDescriptor("icons/word_3.gif"));
        reg.put("ZOOM_IN", Activator.loadImageDescriptor("icons/magnifier-zoom.png"));
        reg.put("ZOOM_OUT", Activator.loadImageDescriptor("icons/magnifier-zoom-out.png"));
        reg.put("ZOOM_ADJUST", Activator.loadImageDescriptor("icons/magnifier-zoom-actual.png"));
    }

    public static Image getImage(String key) {
        return Activator.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return Activator.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static void showExceptionDialog(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, 0, e.toString(), e);
        Activator.log(e);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ResourceString.getResourceString("dialog.title.error"), (String)ResourceString.getResourceString("error.plugin.error.message"), (IStatus)status);
    }

    public static void showErrorDialog(String message) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
        messageBox.setText(ResourceString.getResourceString("dialog.title.error"));
        messageBox.setMessage(ResourceString.getResourceString(message));
        messageBox.open();
    }

    public static void showMessageDialog(String message) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 34);
        messageBox.setText(ResourceString.getResourceString("dialog.title.information"));
        messageBox.setMessage(ResourceString.getResourceString(Format.null2blank(message)));
        messageBox.open();
    }

    public static boolean showConfirmDialog(String message) {
        return Activator.showConfirmDialog(message, 32, 256);
    }

    public static boolean showConfirmDialog(String message, int ok, int cancel) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 2 | ok | cancel);
        messageBox.setText(ResourceString.getResourceString("dialog.title.confirm"));
        messageBox.setMessage(ResourceString.getResourceString(message));
        int result = messageBox.open();
        return result == ok;
    }

    public static String showSaveDialog(String filePath, String[] filterExtensions) {
        String dir = null;
        String fileName = null;
        if (filePath != null && !"".equals(filePath.trim())) {
            File file = new File(filePath.trim());
            dir = file.getParent();
            fileName = file.getName();
        }
        FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        fileDialog.setFilterPath(dir);
        fileDialog.setFileName(fileName);
        fileDialog.setFilterExtensions(filterExtensions);
        return fileDialog.open();
    }

    public static String showDirectoryDialog(String filePath) {
        String fileName = null;
        if (filePath != null && !"".equals(filePath.trim())) {
            File file = new File(filePath.trim());
            fileName = file.getPath();
        }
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
        dialog.setFilterPath(fileName);
        return dialog.open();
    }

    public static void log(Throwable e) {
        e.printStackTrace();
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, e.getMessage(), e));
    }

    public static GraphicalViewer createGraphicalViewer(ERDiagram diagram) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        GraphicalViewerCreator runnable = new GraphicalViewerCreator(display, diagram);
        display.syncExec((Runnable)runnable);
        return runnable.viewer;
    }

    public static Image createImage(GraphicalViewer viewer) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        ImageCreator runnable = new ImageCreator(viewer);
        display.syncExec((Runnable)runnable);
        return runnable.img;
    }

    private static class GraphicalViewerCreator
    implements Runnable {
        private Display display;
        private ERDiagram diagram;
        private GraphicalViewer viewer;

        private GraphicalViewerCreator(Display display, ERDiagram diagram) {
            this.display = display;
            this.diagram = diagram;
        }

        public void run() {
            Shell shell = new Shell(this.display);
            shell.setLayout((Layout)new GridLayout(1, false));
            ERDiagramEditPartFactory editPartFactory = new ERDiagramEditPartFactory();
            this.viewer = new ScrollingGraphicalViewer();
            this.viewer.setControl((Control)new FigureCanvas((Composite)shell));
            PagableFreeformRootEditPart rootEditPart = new PagableFreeformRootEditPart(this.diagram);
            this.viewer.setRootEditPart((RootEditPart)rootEditPart);
            this.viewer.setEditPartFactory((EditPartFactory)editPartFactory);
            this.viewer.setContents((Object)this.diagram);
        }
    }

    private static class ImageCreator
    implements Runnable {
        private GraphicalViewer viewer;
        private Image img = null;

        private ImageCreator(GraphicalViewer viewer) {
            this.viewer = viewer;
        }

        public void run() {
            GC figureCanvasGC = null;
            GC imageGC = null;
            try {
                ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.viewer.getRootEditPart();
                rootEditPart.refresh();
                IFigure rootFigure = rootEditPart.getLayer((Object)"Printable Layers");
                EditPart editPart = this.viewer.getContents();
                editPart.refresh();
                ERDiagram diagram = (ERDiagram)editPart.getModel();
                Rectangle rootFigureBounds = ExportToImageAction.getBounds(diagram, (SimpleRootEditPart)rootEditPart, rootFigure.getBounds());
                Control figureCanvas = this.viewer.getControl();
                figureCanvasGC = new GC((Drawable)figureCanvas);
                this.img = new Image((Device)Display.getCurrent(), rootFigureBounds.width + 20, rootFigureBounds.height + 20);
                imageGC = new GC((Drawable)this.img);
                imageGC.setBackground(figureCanvasGC.getBackground());
                imageGC.setForeground(figureCanvasGC.getForeground());
                imageGC.setFont(figureCanvasGC.getFont());
                imageGC.setLineStyle(figureCanvasGC.getLineStyle());
                imageGC.setLineWidth(figureCanvasGC.getLineWidth());
                imageGC.setAntialias(0);
                SWTGraphics imgGraphics = new SWTGraphics(imageGC);
                imgGraphics.setBackgroundColor(figureCanvas.getBackground());
                imgGraphics.fillRectangle(0, 0, rootFigureBounds.width + 20, rootFigureBounds.height + 20);
                imgGraphics.translate(ExportToImageAction.translateX(rootFigureBounds.x), ExportToImageAction.translateY(rootFigureBounds.y));
                rootFigure.paint((Graphics)imgGraphics);
            }
            finally {
                if (figureCanvasGC != null) {
                    figureCanvasGC.dispose();
                }
                if (imageGC != null) {
                    imageGC.dispose();
                }
            }
        }
    }
}

