/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.common.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.util.Check;

public abstract class AbstractDialog
extends Dialog {
    private CLabel errorMessageText = null;
    private int numColumns;
    private boolean enabledOkButton = true;
    protected boolean initialized = false;

    protected AbstractDialog(Shell parentShell) {
        this(parentShell, 1);
    }

    protected AbstractDialog(Shell parentShell, int numColumns) {
        super(parentShell);
        this.numColumns = numColumns;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(ResourceString.getResourceString(this.getTitle()));
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            GridLayout layout = new GridLayout();
            layout.numColumns = this.numColumns;
            this.initLayout(layout);
            composite.setLayout((Layout)layout);
            composite.setLayoutData(this.createLayoutData());
            this.createErrorComposite(composite);
            this.initialize(composite);
            this.setData();
            this.initialized = true;
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.addListener();
        this.validate();
        return control;
    }

    protected void initLayout(GridLayout layout) {
    }

    protected int getNumColumns() {
        return this.numColumns;
    }

    protected int getErrorLine() {
        return 1;
    }

    protected Object createLayoutData() {
        return new GridData(1808);
    }

    protected void createErrorComposite(Composite parent) {
        this.errorMessageText = new CLabel(parent, 0);
        this.errorMessageText.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 30 * this.getErrorLine();
        gridData.horizontalSpan = this.numColumns;
        this.errorMessageText.setLayoutData((Object)gridData);
    }

    protected Integer getIntegerValue(Text text) {
        String value = text.getText();
        if (Check.isEmpty(value)) {
            return null;
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public final boolean validate() {
        String errorMessage;
        if (!this.initialized) {
            return true;
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        }
        if ((errorMessage = this.getErrorMessage()) != null) {
            this.setMessage(ResourceString.getResourceString(errorMessage));
            return false;
        }
        if (okButton != null && this.enabledOkButton) {
            okButton.setEnabled(true);
        }
        this.setMessage(null);
        return true;
    }

    protected void setMessage(String errorMessage) {
        if (this.errorMessageText != null) {
            if (errorMessage == null) {
                this.errorMessageText.setImage(null);
                this.errorMessageText.setText("");
            } else {
                Image errorIcon = Activator.getImage("ERROR");
                this.errorMessageText.setImage(errorIcon);
                this.errorMessageText.setText(errorMessage);
            }
        }
    }

    protected abstract void initialize(Composite var1);

    protected abstract void setData();

    protected void addListener() {
    }

    protected static boolean isBlank(Text text) {
        return text.getText().trim().length() == 0;
    }

    protected static boolean isBlank(Combo combo) {
        return combo.getText().trim().length() == 0;
    }

    protected void enabledButton(boolean enabled) {
        Button button2;
        this.enabledOkButton = enabled;
        Button button1 = this.getButton(0);
        if (button1 != null) {
            button1.setEnabled(enabled);
        }
        if ((button2 = this.getButton(1)) != null) {
            button2.setEnabled(enabled);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12 || buttonId == 1 || buttonId == 14) {
            this.setReturnCode(buttonId);
            this.close();
        } else if (buttonId == 0) {
            try {
                if (!this.validate()) {
                    return;
                }
                this.perfomeOK();
                this.setReturnCode(buttonId);
                this.close();
            }
            catch (InputException e) {
                this.setMessage(ResourceString.getResourceString(e.getMessage(), e.getArgs()));
                return;
            }
            catch (Exception e) {
                Activator.showExceptionDialog(e);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected abstract String getErrorMessage();

    protected abstract void perfomeOK() throws InputException;

    protected abstract String getTitle();

    protected Button createCheckbox(Composite composite, String title) {
        return CompositeFactory.createCheckbox(this, composite, title, this.getNumColumns());
    }
}

