/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.common.widgets;

import java.util.List;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.widgets.ValidatableTabWrapper;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.view.dialog.common.EditableTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerAppender {
    public static void addTextAreaListener(Text text, AbstractDialog dialog, boolean selectAll, boolean imeOn) {
        ListenerAppender.addFocusListener(text, selectAll, imeOn);
        ListenerAppender.addTraverseListener(text);
        if (dialog != null) {
            ListenerAppender.addModifyListener(text, dialog);
        }
    }

    public static void addTextListener(Text text, AbstractDialog dialog, boolean imeOn) {
        ListenerAppender.addFocusListener(text, imeOn);
        if (dialog != null) {
            ListenerAppender.addModifyListener(text, dialog);
        }
    }

    public static void addFocusListener(Text text, boolean imeOn) {
        ListenerAppender.addFocusListener(text, true, imeOn);
    }

    public static void addFocusListener(final Text text, final boolean selectAll, final boolean imeOn) {
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ERDiagram diagram = (ERDiagram)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getAdapter(ERDiagram.class);
                if (diagram != null && diagram.getDiagramContents().getSettings().isAutoImeChange()) {
                    if (imeOn) {
                        text.getShell().setImeInputMode(10);
                    } else {
                        text.getShell().setImeInputMode(4);
                    }
                }
                if (selectAll) {
                    text.selectAll();
                }
                super.focusGained(e);
            }

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
            }
        });
    }

    public static void addTraverseListener(Text textArea) {
        textArea.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
    }

    public static void addModifyListener(Text text, final AbstractDialog dialog) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                dialog.validate();
            }
        });
    }

    public static void addComboListener(final Combo combo, final AbstractDialog dialog, final boolean imeOn) {
        if (dialog != null) {
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    dialog.validate();
                }
            });
        }
        combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ERDiagram diagram = (ERDiagram)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getAdapter(ERDiagram.class);
                if (diagram != null && diagram.getDiagramContents().getSettings().isAutoImeChange()) {
                    if (imeOn) {
                        combo.getShell().setImeInputMode(10);
                    } else {
                        combo.getShell().setImeInputMode(4);
                    }
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    public static void addCheckBoxListener(final Button button, final AbstractDialog dialog) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                dialog.validate();
            }
        });
        button.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ERDiagram diagram = (ERDiagram)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getAdapter(ERDiagram.class);
                if (diagram != null && diagram.getDiagramContents().getSettings().isAutoImeChange()) {
                    button.getShell().setImeInputMode(4);
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    public static void addTableEditListener(final Table table, final TableEditor tableEditor, final EditableTable editableTable) {
        table.addMouseListener((MouseListener)new MouseAdapter(){

            private Point getSelectedCell(MouseEvent e) {
                int vIndex = table.getSelectionIndex();
                if (vIndex != -1) {
                    TableItem item = table.getItem(vIndex);
                    int hIndex = 0;
                    while (hIndex < table.getColumnCount()) {
                        if (item.getBounds(hIndex).contains(e.x, e.y)) {
                            Point xy = new Point(hIndex, vIndex);
                            xy.y = vIndex;
                            xy.x = hIndex;
                            return xy;
                        }
                        ++hIndex;
                    }
                }
                return null;
            }

            public void mouseDown(MouseEvent event) {
                if (!editableTable.validate()) {
                    return;
                }
                try {
                    Point xy = this.getSelectedCell(event);
                    if (xy != null) {
                        TableItem tableItem = table.getItem(xy.y);
                        ListenerAppender.createEditor(table, tableItem, tableEditor, xy, editableTable);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
            }

            public void mouseDoubleClick(MouseEvent event) {
                try {
                    Point xy = this.getSelectedCell(event);
                    if (xy != null) {
                        editableTable.onDoubleClicked(xy);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
            }
        });
    }

    private static void createEditor(Table table, final TableItem tableItem, TableEditor tableEditor, final Point xy, final EditableTable editableTable) {
        Text text;
        final Control control = editableTable.getControl(xy);
        if (control == null) {
            return;
        }
        if (control instanceof Text) {
            text = (Text)control;
            text.setText(tableItem.getText(xy.x));
        }
        control.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ListenerAppender.setEditValue(control, tableItem, xy, editableTable);
            }
        });
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyevent) {
                if (keyevent.character == '\r') {
                    ListenerAppender.setEditValue(control, tableItem, xy, editableTable);
                } else if (keyevent.character == '\u001b') {
                    control.dispose();
                }
            }
        });
        tableEditor.setEditor(control, tableItem, xy.x);
        control.setFocus();
        table.setSelection(new int[0]);
        if (control instanceof Text) {
            text = (Text)control;
            text.selectAll();
        }
    }

    private static void setEditValue(Control control, TableItem tableItem, Point xy, EditableTable editableTable) {
        editableTable.setData(xy, control);
        if (editableTable.validate()) {
            control.dispose();
        }
    }

    public static void addTabListener(final TabFolder tabFolder, final List<ValidatableTabWrapper> tabWrapperList) {
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = tabFolder.getSelectionIndex();
                ValidatableTabWrapper selectedTabWrapper = (ValidatableTabWrapper)((Object)tabWrapperList.get(index));
                selectedTabWrapper.setInitFocus();
            }
        });
    }

    public static void addModifyListener(final Scale scale, final Spinner spinner, final int diff, final AbstractDialog dialog) {
        if (dialog != null) {
            spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int value = spinner.getSelection();
                    scale.setSelection(value - diff);
                    dialog.validate();
                }
            });
            scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int value = scale.getSelection();
                    spinner.setSelection(value + diff);
                    dialog.validate();
                }
            });
        }
    }
}

