/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.common.widgets.table;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.insightech.er.ResourceString;

public class CustomCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1715411332743091739L;

    public CustomCellEditor(JTable table) {
        super(new JTextField());
        final JTextField component = (JTextField)this.getComponent();
        component.setName("Table.editor");
        component.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.getModifiers() & 2) != 0) {
                    if (e.getKeyCode() == 59) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        component.setText(format.format(new Date()));
                    } else if (e.getKeyCode() == 118 || e.getKeyCode() == 86) {
                        component.paste();
                    } else if (e.getKeyCode() == 99 || e.getKeyCode() == 67) {
                        component.copy();
                    } else if (e.getKeyCode() == 120 || e.getKeyCode() == 88) {
                        component.cut();
                    }
                }
                super.keyPressed(e);
            }
        });
        component.setComponentPopupMenu(new TextFieldPopupMenu());
    }

    private static class CopyAction
    extends TextAction {
        private static final long serialVersionUID = 9018455792592465382L;

        public CopyAction() {
            super(ResourceString.getResourceString("action.title.copy"));
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                target.copy();
            }
        }
    }

    private static class CutAction
    extends TextAction {
        private static final long serialVersionUID = 9018455792592465382L;

        public CutAction() {
            super(ResourceString.getResourceString("action.title.cut"));
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                target.cut();
            }
        }
    }

    private static class PasteAction
    extends TextAction {
        private static final long serialVersionUID = 9018455792592465382L;

        public PasteAction() {
            super(ResourceString.getResourceString("action.title.paste"));
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                target.paste();
            }
        }
    }

    private static class TextFieldPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 5180658114688605208L;

        private TextFieldPopupMenu() {
            FontData fontData = Display.getCurrent().getSystemFont().getFontData()[0];
            Font font = new Font(fontData.getName(), 0, 12);
            JMenuItem cutMenuItem = this.add(new CutAction());
            cutMenuItem.setFont(font);
            JMenuItem copyMenuItem = this.add(new CopyAction());
            copyMenuItem.setFont(font);
            JMenuItem pasteMenuItem = this.add(new PasteAction());
            pasteMenuItem.setFont(font);
        }
    }
}

