/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.db.DBManager;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.editor.model.settings.JDBCDriverSetting;
import org.insightech.er.preference.PreferenceInitializer;
import org.insightech.er.preference.jdbc.JDBCPathDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBManagerBase
implements DBManager {
    private Set<String> reservedWords = new HashSet<String>();
    private Map<String, ClassLoader> loaderMap;

    public DBManagerBase() {
        DBManagerFactory.addDB(this);
        this.reservedWords = this.getReservedWords();
        this.loaderMap = new HashMap<String, ClassLoader>();
    }

    @Override
    public String getURL(String serverName, String dbName, int port) {
        String temp = serverName.replaceAll("\\\\", "\\\\\\\\");
        String url = this.getURL().replaceAll("<SERVER NAME>", temp);
        url = url.replaceAll("<PORT>", String.valueOf(port));
        temp = dbName.replaceAll("\\\\", "\\\\\\\\");
        url = url.replaceAll("<DB NAME>", temp);
        return url;
    }

    @Override
    public Class<Driver> getDriverClass(String driverClassName) {
        Class<Driver> clazz;
        block5: {
            String path = null;
            clazz = null;
            try {
                if (driverClassName.equals("sun.jdbc.odbc.JdbcOdbcDriver")) {
                    return Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                }
                path = PreferenceInitializer.getJDBCDriverPath(this.getId(), driverClassName);
                ClassLoader loader = this.loaderMap.get(path);
                if (loader == null) {
                    loader = this.getClassLoader(path);
                    this.loaderMap.put(path, loader);
                }
                clazz = loader.loadClass(driverClassName);
            }
            catch (Exception exception) {
                JDBCPathDialog dialog = new JDBCPathDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getId(), driverClassName, path, new ArrayList<JDBCDriverSetting>(), false);
                if (dialog.open() != 0) break block5;
                JDBCDriverSetting newDriverSetting = new JDBCDriverSetting(this.getId(), dialog.getDriverClassName(), dialog.getPath());
                List<JDBCDriverSetting> driverSettingList = PreferenceInitializer.getJDBCDriverSettingList();
                if (driverSettingList.contains(newDriverSetting)) {
                    driverSettingList.remove(newDriverSetting);
                }
                driverSettingList.add(newDriverSetting);
                PreferenceInitializer.saveJDBCDriverSettingList(driverSettingList);
                clazz = this.getDriverClass(dialog.getDriverClassName());
            }
        }
        return clazz;
    }

    private ClassLoader getClassLoader(String uri) throws SQLException, MalformedURLException {
        StringTokenizer tokenizer = new StringTokenizer(uri, ";");
        int count = tokenizer.countTokens();
        URL[] urls = new URL[count];
        int i = 0;
        while (i < urls.length) {
            urls[i] = new URL("file", "", tokenizer.nextToken());
            ++i;
        }
        URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
        return loader;
    }

    protected abstract String getURL();

    @Override
    public abstract String getDriverClassName();

    protected Set<String> getReservedWords() {
        HashSet<String> reservedWords = new HashSet<String>();
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(this.getClass().getPackage().getName()) + ".reserved_word");
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            reservedWords.add(keys.nextElement().toUpperCase());
        }
        return reservedWords;
    }

    @Override
    public boolean isReservedWord(String str) {
        return this.reservedWords.contains(str.toUpperCase());
    }

    @Override
    public boolean isSupported(int supportItem) {
        int[] supportItems = this.getSupportItems();
        int i = 0;
        while (i < supportItems.length) {
            if (supportItems[i] == supportItem) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean doesNeedURLDatabaseName() {
        return true;
    }

    @Override
    public boolean doesNeedURLServerName() {
        return true;
    }

    protected abstract int[] getSupportItems();

    @Override
    public List<String> getImportSchemaList(Connection con) throws SQLException {
        ArrayList<String> schemaList = new ArrayList<String>();
        DatabaseMetaData metaData = con.getMetaData();
        try {
            ResultSet rs = metaData.getSchemas();
            while (rs.next()) {
                schemaList.add(rs.getString(1));
            }
        }
        catch (SQLException sQLException) {}
        return schemaList;
    }

    @Override
    public List<String> getSystemSchemaList() {
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }
}

