/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.impl.db2;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.insightech.er.editor.model.dbimport.ImportFromDBManagerBase;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;

public class DB2TableImportManager
extends ImportFromDBManagerBase {
    protected String getViewDefinitionSQL(String schema) {
        return "SELECT TEXT FROM SYSCAT.VIEWS WHERE VIEWSCHEMA = ? AND VIEWNAME = ?";
    }

    protected ImportFromDBManagerBase.ColumnData createColumnData(ResultSet columnSet) throws SQLException {
        ImportFromDBManagerBase.ColumnData columnData = super.createColumnData(columnSet);
        String type = columnData.type.toLowerCase();
        if (type.equals("decimal")) {
            if (columnData.size == 5 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            }
        } else if (type.equals("clob")) {
            if (columnData.size == 0x100000) {
                columnData.size = 0;
            }
        } else if (type.equals("blob")) {
            if (columnData.size == 0x100000) {
                columnData.size = 0;
            }
        } else if (type.equals("dbclob")) {
            if (columnData.size == 0x200000) {
                columnData.size = 0;
            }
        } else if (type.equals("decfloat") && columnData.size == 34) {
            columnData.size = 0;
        }
        return columnData;
    }

    protected Sequence importSequence(String schema, String sequenceName) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block15: {
            Sequence sequence;
            stmt = null;
            rs = null;
            try {
                stmt = this.con.prepareStatement("SELECT * FROM SYSCAT.SEQUENCES WHERE SEQSCHEMA = ? AND SEQNAME = ?");
                stmt.setString(1, schema);
                stmt.setString(2, sequenceName);
                rs = stmt.executeQuery();
                if (!rs.next()) break block15;
                Sequence sequence2 = new Sequence();
                sequence2.setName(sequenceName);
                sequence2.setSchema(schema);
                sequence2.setIncrement(rs.getInt("INCREMENT"));
                sequence2.setMinValue(rs.getLong("MINVALUE"));
                BigDecimal maxValue = rs.getBigDecimal("MAXVALUE");
                int dataTypeId = rs.getInt("DATATYPEID");
                String dataType = null;
                if (dataTypeId == 16) {
                    dataType = "DECIMAL(p)";
                    sequence2.setDecimalSize(rs.getInt("PRECISION"));
                } else if (dataTypeId == 24) {
                    dataType = "INTEGER";
                    if (maxValue.intValue() == Integer.MAX_VALUE) {
                        maxValue = null;
                    }
                } else if (dataTypeId == 20) {
                    dataType = "BIGINT";
                    if (maxValue.longValue() == Long.MAX_VALUE) {
                        maxValue = null;
                    }
                } else if (dataTypeId == 28) {
                    dataType = "SMALLINT";
                    if (maxValue.intValue() == Short.MAX_VALUE) {
                        maxValue = null;
                    }
                } else {
                    dataType = "";
                }
                sequence2.setDataType(dataType);
                sequence2.setMaxValue(maxValue);
                sequence2.setStart(rs.getLong("START"));
                sequence2.setCache(rs.getInt("CACHE"));
                boolean cycle = false;
                if ("Y".equals(rs.getString("CYCLE"))) {
                    cycle = true;
                }
                sequence2.setCycle(cycle);
                boolean order = false;
                if ("Y".equals(rs.getString("ORDER"))) {
                    order = true;
                }
                sequence2.setOrder(order);
                sequence = sequence2;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                throw throwable;
            }
            this.close(rs);
            this.close(stmt);
            return sequence;
        }
        this.close(rs);
        this.close(stmt);
        return null;
    }
}

