/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.impl.hsqldb;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.insightech.er.editor.model.dbimport.ImportFromDBManagerBase;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;

public class HSQLDBTableImportManager
extends ImportFromDBManagerBase {
    protected String getViewDefinitionSQL(String schema) {
        return "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? ";
    }

    protected ImportFromDBManagerBase.ColumnData createColumnData(ResultSet columnSet) throws SQLException {
        ImportFromDBManagerBase.ColumnData columnData = super.createColumnData(columnSet);
        String type = columnData.type.toLowerCase();
        if (type.startsWith("decimal")) {
            if (columnData.size == 128 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            } else if (columnData.size == 646456993 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            }
        } else if (type.startsWith("numeric")) {
            if (columnData.size == 128 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            } else if (columnData.size == 646456993 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            }
        } else if (type.startsWith("float")) {
            if (columnData.size == 17) {
                columnData.size = 0;
            } else if (columnData.size == 646456993 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            }
        } else if (type.startsWith("clob")) {
            if (columnData.size == 0x1000000) {
                columnData.size = 0;
            }
        } else if (type.startsWith("blob")) {
            if (columnData.size == 0x1000000) {
                columnData.size = 0;
            }
        } else if (type.startsWith("varchar")) {
            if (columnData.size == 0x1000000) {
                columnData.size = 0;
                columnData.type = "longvarchar";
            }
        } else if (type.startsWith("varbinary")) {
            if (columnData.size == 0x1000000) {
                columnData.size = 0;
                columnData.type = "longvarbinary";
            }
        } else if (type.startsWith("timestamp")) {
            columnData.size -= 20;
            if (columnData.size == 6) {
                columnData.size = 0;
            }
        }
        return columnData;
    }

    protected Sequence importSequence(String schema, String sequenceName) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block12: {
            Sequence sequence;
            stmt = null;
            rs = null;
            try {
                stmt = this.con.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA = ? AND SEQUENCE_NAME = ?");
                stmt.setString(1, schema);
                stmt.setString(2, sequenceName);
                rs = stmt.executeQuery();
                if (!rs.next()) break block12;
                Sequence sequence2 = new Sequence();
                sequence2.setName(sequenceName);
                sequence2.setSchema(schema);
                sequence2.setIncrement(rs.getInt("INCREMENT"));
                Long minValue = rs.getLong("MINIMUM_VALUE");
                Long maxValue = rs.getLong("MAXIMUM_VALUE");
                String dataType = rs.getString("DATA_TYPE");
                sequence2.setDataType(dataType);
                if ("INTEGER".equals(dataType)) {
                    if (maxValue.intValue() == Integer.MAX_VALUE) {
                        maxValue = null;
                    }
                    if (minValue.intValue() == Integer.MIN_VALUE) {
                        minValue = null;
                    }
                } else if ("BIGINT".equals(dataType)) {
                    if (maxValue == Long.MAX_VALUE) {
                        maxValue = null;
                    }
                    if ((long)minValue.intValue() == Long.MIN_VALUE) {
                        minValue = null;
                    }
                }
                sequence2.setMinValue(minValue);
                if (maxValue != null) {
                    sequence2.setMaxValue(new BigDecimal(maxValue));
                } else {
                    sequence2.setMaxValue(null);
                }
                sequence2.setStart(rs.getLong("START_WITH"));
                boolean cycle = false;
                if ("YES".equals(rs.getString("CYCLE_OPTION"))) {
                    cycle = true;
                }
                sequence2.setCycle(cycle);
                sequence = sequence2;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                throw throwable;
            }
            this.close(rs);
            this.close(stmt);
            return sequence;
        }
        this.close(rs);
        this.close(stmt);
        return null;
    }
}

