/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.impl.mysql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.insightech.er.db.DBManagerBase;
import org.insightech.er.db.impl.mysql.MySQLDDLCreator;
import org.insightech.er.db.impl.mysql.MySQLPreTableExportManager;
import org.insightech.er.db.impl.mysql.MySQLPreTableImportManager;
import org.insightech.er.db.impl.mysql.MySQLSqlTypeManager;
import org.insightech.er.db.impl.mysql.MySQLTableImportManager;
import org.insightech.er.db.impl.mysql.MySQLTableProperties;
import org.insightech.er.db.impl.mysql.tablespace.MySQLTablespaceProperties;
import org.insightech.er.db.sqltype.SqlTypeManager;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.db.PreTableExportManager;
import org.insightech.er.editor.model.dbexport.ddl.DDLCreator;
import org.insightech.er.editor.model.dbimport.ImportFromDBManager;
import org.insightech.er.editor.model.dbimport.PreImportFromDBManager;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.properties.TableProperties;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.TablespaceProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDBManager
extends DBManagerBase {
    public static final String ID = "MySQL";
    private static final ResourceBundle CHARACTER_SET_RESOURCE = ResourceBundle.getBundle("mysql_characterset");

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    protected String getURL() {
        return "jdbc:mysql://<SERVER NAME>:<PORT>/<DB NAME>";
    }

    @Override
    public int getDefaultPort() {
        return 3306;
    }

    @Override
    public SqlTypeManager getSqlTypeManager() {
        return new MySQLSqlTypeManager();
    }

    @Override
    public TableProperties createTableProperties(TableProperties tableProperties) {
        if (tableProperties != null && tableProperties instanceof MySQLTableProperties) {
            return tableProperties;
        }
        return new MySQLTableProperties();
    }

    @Override
    public DDLCreator getDDLCreator(ERDiagram diagram, boolean semicolon) {
        return new MySQLDDLCreator(diagram, semicolon);
    }

    @Override
    public List<String> getIndexTypeList(ERTable table) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("BTREE");
        return list;
    }

    @Override
    protected int[] getSupportItems() {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        return nArray;
    }

    @Override
    public ImportFromDBManager getTableImportManager() {
        return new MySQLTableImportManager();
    }

    @Override
    public PreImportFromDBManager getPreTableImportManager() {
        return new MySQLPreTableImportManager();
    }

    @Override
    public PreTableExportManager getPreTableExportManager() {
        return new MySQLPreTableExportManager();
    }

    @Override
    public TablespaceProperties createTablespaceProperties() {
        return new MySQLTablespaceProperties();
    }

    @Override
    public TablespaceProperties checkTablespaceProperties(TablespaceProperties tablespaceProperties) {
        if (!(tablespaceProperties instanceof MySQLTablespaceProperties)) {
            return new MySQLTablespaceProperties();
        }
        return tablespaceProperties;
    }

    @Override
    public String[] getCurrentTimeValue() {
        return new String[]{"NOW(), SYSDATE()"};
    }

    @Override
    public BigDecimal getSequenceMaxValue() {
        return null;
    }

    public static List<String> getCharacterSetList() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<String> keys = CHARACTER_SET_RESOURCE.getKeys();
        while (keys.hasMoreElements()) {
            list.add(keys.nextElement());
        }
        return list;
    }

    public static List<String> getCollationList(String characterset) {
        ArrayList<String> list = new ArrayList<String>();
        if (characterset != null) {
            try {
                String values = CHARACTER_SET_RESOURCE.getString(characterset);
                if (values != null) {
                    StringTokenizer tokenizer = new StringTokenizer(values, ",");
                    while (tokenizer.hasMoreElements()) {
                        String token = tokenizer.nextToken().trim();
                        list.add(token);
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return list;
    }
}

