/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.impl.mysql.tablespace;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.TablespaceProperties;
import org.insightech.er.util.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLTablespaceProperties
implements TablespaceProperties {
    private static final long serialVersionUID = 7900101196638704362L;
    private String dataFile;
    private String logFileGroup;
    private String extentSize;
    private String initialSize;
    private String engine;

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public String getLogFileGroup() {
        return this.logFileGroup;
    }

    public void setLogFileGroup(String logFileGroup) {
        this.logFileGroup = logFileGroup;
    }

    public String getExtentSize() {
        return this.extentSize;
    }

    public void setExtentSize(String extentSize) {
        this.extentSize = extentSize;
    }

    public String getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(String initialSize) {
        this.initialSize = initialSize;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    @Override
    public TablespaceProperties clone() {
        MySQLTablespaceProperties properties = new MySQLTablespaceProperties();
        properties.dataFile = this.dataFile;
        properties.engine = this.engine;
        properties.extentSize = this.extentSize;
        properties.initialSize = this.initialSize;
        properties.logFileGroup = this.logFileGroup;
        return properties;
    }

    @Override
    public LinkedHashMap<String, String> getPropertiesMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("label.tablespace.data.file", this.getDataFile());
        map.put("label.tablespace.log.file.group", this.getLogFileGroup());
        map.put("label.tablespace.extent.size", this.getExtentSize());
        map.put("label.tablespace.initial.size", this.getInitialSize());
        map.put("label.storage.engine", this.getEngine());
        return map;
    }

    @Override
    public List<String> validate() {
        ArrayList<String> errorMessage = new ArrayList<String>();
        if (Check.isEmptyTrim(this.getDataFile())) {
            errorMessage.add("error.tablespace.data.file.empty");
        }
        if (Check.isEmptyTrim(this.getLogFileGroup())) {
            errorMessage.add("error.tablespace.log.file.group.empty");
        }
        if (Check.isEmptyTrim(this.getEngine())) {
            errorMessage.add("error.tablespace.storage.engine.empty");
        }
        return errorMessage;
    }
}

