/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.sqltype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.db.sqltype.SqlTypeFactory;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.TypeData;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlType
implements Serializable {
    private static Logger logger = Logger.getLogger(SqlType.class.getName());
    private static final long serialVersionUID = -8273043043893517634L;
    public static final String SQL_TYPE_ID_SERIAL = "serial";
    public static final String SQL_TYPE_ID_BIG_SERIAL = "bigserial";
    public static final String SQL_TYPE_ID_INTEGER = "integer";
    public static final String SQL_TYPE_ID_BIG_INT = "bigint";
    private static final Pattern NEED_LENGTH_PATTERN = Pattern.compile(".+\\([a-zA-Z][,\\)].*");
    private static final Pattern NEED_DECIMAL_PATTERN1 = Pattern.compile(".+\\([a-zA-Z],[a-zA-Z]\\)");
    private static final Pattern NEED_DECIMAL_PATTERN2 = Pattern.compile(".+\\([a-zA-Z]\\).*\\([a-zA-Z]\\)");
    private static final List<SqlType> SQL_TYPE_LIST = new ArrayList<SqlType>();
    private String name;
    private Class javaClass;
    private boolean needArgs;
    boolean fullTextIndexable;
    private static Map<String, Map<TypeKey, SqlType>> dbSqlTypeMap = new HashMap<String, Map<TypeKey, SqlType>>();
    private static Map<String, Map<SqlType, String>> dbAliasMap = new HashMap<String, Map<SqlType, String>>();

    static {
        try {
            SqlTypeFactory.load();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }

    public SqlType(String name, Class javaClass, boolean needArgs, boolean fullTextIndexable) {
        this.name = name;
        this.javaClass = javaClass;
        this.needArgs = needArgs;
        this.fullTextIndexable = fullTextIndexable;
        SQL_TYPE_LIST.add(this);
    }

    public static void setDBAliasMap(Map<String, Map<SqlType, String>> dbAliasMap, Map<String, Map<TypeKey, SqlType>> dbSqlTypeMap) {
        SqlType.dbAliasMap = dbAliasMap;
        SqlType.dbSqlTypeMap = dbSqlTypeMap;
    }

    public void addToSqlTypeMap(String typeKeyId, String database) {
        int size = 0;
        if (!this.isUnsupported(database)) {
            if (this.isNeedLength(database)) {
                size = 1;
            }
            TypeKey typeKey = new TypeKey(typeKeyId, size);
            Map<TypeKey, SqlType> sqlTypeMap = dbSqlTypeMap.get(database);
            sqlTypeMap.put(typeKey, this);
        }
    }

    public String getId() {
        return this.name;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public boolean doesNeedArgs() {
        return this.needArgs;
    }

    public boolean isFullTextIndexable() {
        return this.fullTextIndexable;
    }

    protected static List<SqlType> getAllSqlType() {
        return SQL_TYPE_LIST;
    }

    public static SqlType valueOf(String database, String alias) {
        int size = 0;
        if (alias.indexOf("(") != -1) {
            size = 1;
        }
        return SqlType.valueOf(database, alias, size);
    }

    public static SqlType valueOf(String database, String alias, int size) {
        TypeKey typeKey;
        if (alias == null) {
            return null;
        }
        Map<TypeKey, SqlType> sqlTypeMap = dbSqlTypeMap.get(database);
        SqlType sqlType = sqlTypeMap.get(typeKey = new TypeKey(alias, size));
        if (sqlType == null) {
            alias = alias.replaceAll("\\(.*\\)", "");
            typeKey = new TypeKey(alias = alias.replaceAll(" UNSIGNED", ""), size);
            sqlType = sqlTypeMap.get(typeKey);
            if (sqlType == null) {
                typeKey = new TypeKey(alias, 0);
                sqlType = sqlTypeMap.get(typeKey);
            }
        }
        return sqlType;
    }

    public static SqlType valueOfId(String id) {
        SqlType sqlType = null;
        if (id == null) {
            return null;
        }
        for (SqlType type : SQL_TYPE_LIST) {
            if (!id.equals(type.getId())) continue;
            sqlType = type;
        }
        return sqlType;
    }

    public boolean isNeedLength(String database) {
        String alias = this.getAlias(database);
        if (alias == null) {
            return false;
        }
        Matcher matcher = NEED_LENGTH_PATTERN.matcher(alias);
        return matcher.matches();
    }

    public boolean isNeedDecimal(String database) {
        String alias = this.getAlias(database);
        if (alias == null) {
            return false;
        }
        Matcher matcher = NEED_DECIMAL_PATTERN1.matcher(alias);
        if (matcher.matches()) {
            return true;
        }
        matcher = NEED_DECIMAL_PATTERN2.matcher(alias);
        return matcher.matches();
    }

    public boolean isTimestamp() {
        return this.javaClass == Date.class;
    }

    public boolean isNumber() {
        return Number.class.isAssignableFrom(this.javaClass);
    }

    public static List<String> getAliasList(String database) {
        Map<SqlType, String> aliasMap = dbAliasMap.get(database);
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        for (Map.Entry<SqlType, String> entry : aliasMap.entrySet()) {
            String alias = entry.getValue();
            aliases.add(alias);
        }
        ArrayList<String> list = new ArrayList<String>(aliases);
        Collections.sort(list);
        return list;
    }

    public String getAlias(String database) {
        Map<SqlType, String> aliasMap = dbAliasMap.get(database);
        return aliasMap.get(this);
    }

    public boolean isUnsupported(String database) {
        String alias = this.getAlias(database);
        return alias == null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlType)) {
            return false;
        }
        SqlType type = (SqlType)obj;
        return this.name.equals(type.name);
    }

    public String toString() {
        return this.getId();
    }

    public static void main(String[] args) {
        int maxIdLength = 37;
        StringBuilder msg = new StringBuilder();
        msg.append("\n");
        List<SqlType> list = SqlType.getAllSqlType();
        List<String> dbList = DBManagerFactory.getAllDBList();
        String str = "ID";
        msg.append(str);
        for (String db : dbList) {
            int spaceLength = maxIdLength - str.length();
            if (spaceLength < 4) {
                spaceLength = 4;
            }
            int i = 0;
            while (i < spaceLength) {
                msg.append(" ");
                ++i;
            }
            str = db;
            msg.append(db);
        }
        msg.append("\n");
        msg.append("\n");
        StringBuilder builder = new StringBuilder();
        int errorCount = 0;
        for (SqlType type : list) {
            builder.append(type.name);
            int spaceLength = maxIdLength - type.name.length();
            if (spaceLength < 4) {
                spaceLength = 4;
            }
            for (String db : dbList) {
                int i = 0;
                while (i < spaceLength) {
                    builder.append(" ");
                    ++i;
                }
                String alias = type.getAlias(db);
                if (alias != null) {
                    builder.append(type.getAlias(db));
                    spaceLength = maxIdLength - type.getAlias(db).length();
                    if (spaceLength >= 4) continue;
                    spaceLength = 4;
                    continue;
                }
                if (type.isUnsupported(db)) {
                    builder.append("\u7b06\uff61\u7b06\uff61\u7b06\uff61\u7b06\uff61\u7b06\uff61\u7b06\uff61");
                } else {
                    builder.append("\u7b06\ufffd\u8513\u7b06\ufffd\u8513\u7b06\ufffd\u8513");
                    ++errorCount;
                }
                spaceLength = maxIdLength - "\u7b06\uff61\u7b06\uff61\u7b06\uff61\u7b06\uff61\u7b06\uff61\u7b06\uff61".length();
                if (spaceLength >= 4) continue;
                spaceLength = 4;
            }
            builder.append("\r\n");
        }
        String allColumn = builder.toString();
        msg.append(String.valueOf(allColumn) + "\n");
        int errorCount2 = 0;
        int errorCount3 = 0;
        for (String db : dbList) {
            msg.append("-- for " + db + "\n");
            msg.append("CREATE TABLE TYPE_TEST (\n");
            int count = 0;
            for (SqlType type : list) {
                TypeData typeData;
                String alias = type.getAlias(db);
                if (alias == null) continue;
                if (count != 0) {
                    msg.append(",\n");
                }
                msg.append("\tCOL_" + count + " ");
                if (type.isNeedLength(db) && type.isNeedDecimal(db)) {
                    typeData = new TypeData(new Integer(1), new Integer(1), false, null, false, null);
                    str = Format.formatType(type, typeData, db);
                    if (str.equals(alias)) {
                        ++errorCount3;
                        msg.append("\uff83\ufffd");
                    }
                } else if (type.isNeedLength(db)) {
                    typeData = new TypeData(new Integer(1), null, false, null, false, null);
                    str = Format.formatType(type, typeData, db);
                    if (str.equals(alias)) {
                        ++errorCount3;
                        msg.append("\uff83\ufffd");
                    }
                } else if (type.isNeedDecimal(db)) {
                    typeData = new TypeData(null, new Integer(1), false, null, false, null);
                    str = Format.formatType(type, typeData, db);
                    if (str.equals(alias)) {
                        ++errorCount3;
                        msg.append("\uff83\ufffd");
                    }
                } else {
                    str = type.doesNeedArgs() ? String.valueOf(alias) + "('1')" : alias;
                }
                if (str != null) {
                    Matcher m1 = NEED_LENGTH_PATTERN.matcher(str);
                    Matcher m2 = NEED_DECIMAL_PATTERN1.matcher(str);
                    Matcher m3 = NEED_DECIMAL_PATTERN2.matcher(str);
                    if (m1.matches() || m2.matches() || m3.matches()) {
                        ++errorCount2;
                        msg.append("\uff83\ufffd");
                    }
                }
                msg.append(str);
                ++count;
            }
            msg.append("\n");
            msg.append(");\n");
            msg.append("\n");
        }
        msg.append("\n");
        msg.append(String.valueOf(errorCount) + " \u86df\u4e5d\ufffd\u8759\u4e5d\u2032\u879f\u753b\u92e4\u7e3a\uff67\u7e3a\u962a\u222a\u7e3a\u5e19\uff53\u7e3a\uff67\u7e3a\u52b1\u25c6\u7e32\ufffdn");
        msg.append(String.valueOf(errorCount2) + " \u86df\u4e5d\ufffd\u8b28\uff70\u87c4\u601c\u689b\u7e3a\uff6e\u8b16\ufffd\uff6e\u58f9\u2032\u8373\u5d0e\uff76\uff73\u7e3a\u52b1\u203b\u7e3a\ufffd\u222a\u7e3a\u5436\ufffd\n");
        msg.append(String.valueOf(errorCount3) + " \u86df\u4e5d\ufffd\u8b28\uff70\u87c4\u601c\u689b\u7e3a\uff6e\u8b16\ufffd\uff6e\u58f9\u2032\u83f4\u541d\ufffd\u7e3a\uff67\u7e3a\u5436\ufffd\n");
        logger.info(msg.toString());
    }

    public static class TypeKey {
        private String alias;
        private int size;

        public TypeKey(String alias, int size) {
            if (alias != null) {
                alias = alias.toUpperCase();
            }
            this.alias = alias;
            this.size = size == 0 ? 0 : (size == Integer.MAX_VALUE ? 0 : (size > 0 ? 1 : -1));
        }

        public boolean equals(Object obj) {
            TypeKey other = (TypeKey)obj;
            if (this.alias == null) {
                if (other.alias == null) {
                    return this.size == other.size;
                }
                return false;
            }
            return this.alias.equals(other.alias) && this.size == other.size;
        }

        public int hashCode() {
            if (this.alias == null) {
                return this.size;
            }
            return this.alias.hashCode() * 10 + this.size;
        }

        public String toString() {
            return "TypeKey [alias=" + this.alias + ", size=" + this.size + "]";
        }
    }
}

