/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.insightech.er.Activator;
import org.insightech.er.Resources;
import org.insightech.er.editor.ERDiagramMultiPageEditor;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPartFactory;
import org.insightech.er.editor.controller.editpart.element.PagableFreeformRootEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.view.ERDiagramGotoMarker;
import org.insightech.er.editor.view.ERDiagramPopupMenuManager;
import org.insightech.er.editor.view.action.category.CategoryManageAction;
import org.insightech.er.editor.view.action.category.ChangeFreeLayoutAction;
import org.insightech.er.editor.view.action.category.ChangeShowReferredTablesAction;
import org.insightech.er.editor.view.action.dbexport.ExportToDBAction;
import org.insightech.er.editor.view.action.dbexport.ExportToDDLAction;
import org.insightech.er.editor.view.action.dbexport.ExportToDictionaryAction;
import org.insightech.er.editor.view.action.dbexport.ExportToExcelAction;
import org.insightech.er.editor.view.action.dbexport.ExportToHtmlAction;
import org.insightech.er.editor.view.action.dbexport.ExportToImageAction;
import org.insightech.er.editor.view.action.dbexport.ExportToJavaAction;
import org.insightech.er.editor.view.action.dbexport.ExportToTestDataAction;
import org.insightech.er.editor.view.action.dbexport.ExportToTranslationDictionaryAction;
import org.insightech.er.editor.view.action.dbimport.ImportFromDBAction;
import org.insightech.er.editor.view.action.dbimport.ImportFromFileAction;
import org.insightech.er.editor.view.action.edit.ChangeBackgroundColorAction;
import org.insightech.er.editor.view.action.edit.CopyAction;
import org.insightech.er.editor.view.action.edit.DeleteWithoutUpdateAction;
import org.insightech.er.editor.view.action.edit.EditAllAttributesAction;
import org.insightech.er.editor.view.action.edit.PasteAction;
import org.insightech.er.editor.view.action.edit.SelectAllContentsAction;
import org.insightech.er.editor.view.action.group.GroupManageAction;
import org.insightech.er.editor.view.action.line.DefaultLineAction;
import org.insightech.er.editor.view.action.line.ERDiagramAlignmentAction;
import org.insightech.er.editor.view.action.line.ERDiagramMatchHeightAction;
import org.insightech.er.editor.view.action.line.ERDiagramMatchWidthAction;
import org.insightech.er.editor.view.action.line.HorizontalLineAction;
import org.insightech.er.editor.view.action.line.ResizeModelAction;
import org.insightech.er.editor.view.action.line.RightAngleLineAction;
import org.insightech.er.editor.view.action.line.VerticalLineAction;
import org.insightech.er.editor.view.action.option.OptionSettingAction;
import org.insightech.er.editor.view.action.option.notation.ChangeCapitalAction;
import org.insightech.er.editor.view.action.option.notation.ChangeNotationExpandGroupAction;
import org.insightech.er.editor.view.action.option.notation.ChangeStampAction;
import org.insightech.er.editor.view.action.option.notation.LockEditAction;
import org.insightech.er.editor.view.action.option.notation.TooltipAction;
import org.insightech.er.editor.view.action.option.notation.design.ChangeDesignToFrameAction;
import org.insightech.er.editor.view.action.option.notation.design.ChangeDesignToFunnyAction;
import org.insightech.er.editor.view.action.option.notation.design.ChangeDesignToSimpleAction;
import org.insightech.er.editor.view.action.option.notation.level.ChangeNotationLevelToColumnAction;
import org.insightech.er.editor.view.action.option.notation.level.ChangeNotationLevelToDetailAction;
import org.insightech.er.editor.view.action.option.notation.level.ChangeNotationLevelToExcludeTypeAction;
import org.insightech.er.editor.view.action.option.notation.level.ChangeNotationLevelToNameAndKeyAction;
import org.insightech.er.editor.view.action.option.notation.level.ChangeNotationLevelToOnlyKeyAction;
import org.insightech.er.editor.view.action.option.notation.level.ChangeNotationLevelToOnlyTitleAction;
import org.insightech.er.editor.view.action.option.notation.system.ChangeToIDEF1XNotationAction;
import org.insightech.er.editor.view.action.option.notation.system.ChangeToIENotationAction;
import org.insightech.er.editor.view.action.option.notation.type.ChangeViewToBothAction;
import org.insightech.er.editor.view.action.option.notation.type.ChangeViewToLogicalAction;
import org.insightech.er.editor.view.action.option.notation.type.ChangeViewToPhysicalAction;
import org.insightech.er.editor.view.action.printer.PageSettingAction;
import org.insightech.er.editor.view.action.printer.PrintImageAction;
import org.insightech.er.editor.view.action.search.SearchAction;
import org.insightech.er.editor.view.action.testdata.TestDataCreateAction;
import org.insightech.er.editor.view.action.tracking.ChangeTrackingAction;
import org.insightech.er.editor.view.action.translation.TranslationManageAction;
import org.insightech.er.editor.view.action.zoom.ZoomAdjustAction;
import org.insightech.er.editor.view.contributor.ERDiagramActionBarContributor;
import org.insightech.er.editor.view.drag_drop.ERDiagramTransferDragSourceListener;
import org.insightech.er.editor.view.drag_drop.ERDiagramTransferDropTargetListener;
import org.insightech.er.editor.view.outline.ERDiagramOutlinePage;
import org.insightech.er.editor.view.outline.ERDiagramOutlinePopupMenuManager;
import org.insightech.er.editor.view.property_source.ERDiagramPropertySourceProvider;
import org.insightech.er.editor.view.tool.ERDiagramPaletteRoot;
import org.insightech.er.extention.ExtensionLoader;

public class ERDiagramEditor
extends GraphicalEditorWithPalette {
    private ERDiagram diagram;
    private ERDiagramEditPartFactory editPartFactory;
    private ERDiagramOutlinePage outlinePage;
    private IGotoMarker gotoMaker;
    private ERDiagramActionBarContributor actionBarContributor;
    private ZoomComboContributionItem zoomComboContributionItem;
    private MenuManager outlineMenuMgr;
    private Map<IMarker, Object> markedObjectMap = new HashMap<IMarker, Object>();
    private PropertySheetPage propertySheetPage;
    private ExtensionLoader extensionLoader;
    private boolean isDirty;

    public ERDiagramEditor(ERDiagram diagram, ERDiagramEditPartFactory editPartFactory, ZoomComboContributionItem zoomComboContributionItem, ERDiagramOutlinePage outlinePage) {
        DefaultEditDomain domain = new DefaultEditDomain((IEditorPart)this);
        this.setEditDomain(domain);
        this.diagram = diagram;
        this.editPartFactory = editPartFactory;
        this.zoomComboContributionItem = zoomComboContributionItem;
        this.outlinePage = outlinePage;
        this.propertySheetPage = new PropertySheetPage();
        this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new ERDiagramPropertySourceProvider());
        try {
            this.extensionLoader = new ExtensionLoader(this);
        }
        catch (CoreException e) {
            Activator.showExceptionDialog(e);
        }
    }

    public void dispose() {
        this.getSelectionSynchronizer().removeViewer(this.outlinePage.getViewer());
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getCommandStack().markSaveLocation();
        this.isDirty = false;
    }

    public void commandStackChanged(EventObject eventObject) {
        this.firePropertyChange(257);
        super.commandStackChanged(eventObject);
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)this.editPartFactory);
        this.initViewerAction(viewer);
        this.initDragAndDrop(viewer);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        viewer.setProperty("SnapToGrid.isEnabled", (Object)true);
        viewer.setProperty("SnapToGrid.isVisible", (Object)true);
        viewer.setProperty("SnapToGeometry.isEnabled", (Object)true);
        ERDiagramPopupMenuManager menuMgr = new ERDiagramPopupMenuManager(this.getActionRegistry(), this.diagram);
        this.extensionLoader.addERDiagramPopupMenu(menuMgr, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)menuMgr);
        viewer.setContents((Object)this.diagram);
        this.outlineMenuMgr = new ERDiagramOutlinePopupMenuManager(this.diagram, this.getActionRegistry(), this.outlinePage.getOutlineActionRegistory(), this.outlinePage.getViewer());
        this.gotoMaker = new ERDiagramGotoMarker(this);
    }

    protected PaletteRoot getPaletteRoot() {
        return new ERDiagramPaletteRoot();
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (type == IContentOutlinePage.class) {
            return this.outlinePage;
        }
        if (type == IGotoMarker.class) {
            return this.gotoMaker;
        }
        if (type == IPropertySheetPage.class) {
            return this.propertySheetPage;
        }
        return super.getAdapter(type);
    }

    public void changeCategory() {
        this.outlinePage.setCategory((EditDomain)this.getEditDomain(), this.getGraphicalViewer(), this.outlineMenuMgr, this.getActionRegistry());
        this.getSelectionSynchronizer().addViewer(this.outlinePage.getViewer());
    }

    public void removeSelection() {
        this.getSelectionSynchronizer().removeViewer(this.outlinePage.getViewer());
    }

    protected void createActions() {
        IAction action2;
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        List selectionActionList = this.getSelectionActions();
        ArrayList<IAction> actionList = new ArrayList<IAction>(Arrays.asList(new IAction[]{new ChangeViewToLogicalAction(this), new ChangeViewToPhysicalAction(this), new ChangeViewToBothAction(this), new ChangeToIENotationAction(this), new ChangeToIDEF1XNotationAction(this), new ChangeNotationLevelToColumnAction(this), new ChangeNotationLevelToExcludeTypeAction(this), new ChangeNotationLevelToDetailAction(this), new ChangeNotationLevelToOnlyTitleAction(this), new ChangeNotationLevelToOnlyKeyAction(this), new ChangeNotationLevelToNameAndKeyAction(this), new ChangeNotationExpandGroupAction(this), new ChangeDesignToFunnyAction(this), new ChangeDesignToFrameAction(this), new ChangeDesignToSimpleAction(this), new ChangeCapitalAction(this), new ChangeStampAction(this), new GroupManageAction(this), new ChangeTrackingAction(this), new OptionSettingAction(this), new CategoryManageAction(this), new ChangeFreeLayoutAction(this), new ChangeShowReferredTablesAction(this), new TranslationManageAction(this), new TestDataCreateAction(this), new ImportFromDBAction(this), new ImportFromFileAction(this), new ExportToImageAction(this), new ExportToExcelAction(this), new ExportToHtmlAction(this), new ExportToJavaAction(this), new ExportToDDLAction(this), new ExportToDictionaryAction(this), new ExportToTranslationDictionaryAction(this), new ExportToTestDataAction(this), new PageSettingAction(this), new EditAllAttributesAction(this), new DirectEditAction((IWorkbenchPart)this), new ERDiagramAlignmentAction((IWorkbenchPart)this, 1), new ERDiagramAlignmentAction((IWorkbenchPart)this, 2), new ERDiagramAlignmentAction((IWorkbenchPart)this, 4), new ERDiagramAlignmentAction((IWorkbenchPart)this, 8), new ERDiagramAlignmentAction((IWorkbenchPart)this, 16), new ERDiagramAlignmentAction((IWorkbenchPart)this, 32), new ERDiagramMatchWidthAction((IWorkbenchPart)this), new ERDiagramMatchHeightAction((IWorkbenchPart)this), new HorizontalLineAction(this), new VerticalLineAction(this), new RightAngleLineAction(this), new DefaultLineAction(this), new CopyAction((IWorkbenchPart)this), new PasteAction((IWorkbenchPart)this), new SearchAction(this), new ResizeModelAction(this), new PrintImageAction(this), new DeleteWithoutUpdateAction(this), new SelectAllContentsAction((IWorkbenchPart)this)}));
        actionList.addAll(this.extensionLoader.createExtendedActions());
        for (IAction action2 : actionList) {
            if (action2 instanceof SelectionAction) {
                IAction originalAction = registry.getAction((Object)action2.getId());
                if (originalAction != null) {
                    selectionActionList.remove(originalAction);
                }
                selectionActionList.add(action2.getId());
            }
            registry.registerAction(action2);
        }
        action2 = registry.getAction((Object)SearchAction.ID);
        this.addKeyHandler(action2);
    }

    private void initViewerAction(GraphicalViewer viewer) {
        PagableFreeformRootEditPart rootEditPart = new PagableFreeformRootEditPart(this.diagram);
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager manager = rootEditPart.getZoomManager();
        double[] zoomLevels = new double[]{0.1, 0.25, 0.5, 0.75, 0.8, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 10.0, 20.0};
        manager.setZoomLevels(zoomLevels);
        ArrayList<String> zoomContributions = new ArrayList<String>();
        zoomContributions.add(ZoomManager.FIT_ALL);
        zoomContributions.add(ZoomManager.FIT_HEIGHT);
        zoomContributions.add(ZoomManager.FIT_WIDTH);
        manager.setZoomLevelContributions(zoomContributions);
        ZoomInAction zoomInAction = new ZoomInAction(manager);
        ZoomOutAction zoomOutAction = new ZoomOutAction(manager);
        ZoomAdjustAction zoomAdjustAction = new ZoomAdjustAction(manager);
        this.getActionRegistry().registerAction((IAction)zoomInAction);
        this.getActionRegistry().registerAction((IAction)zoomOutAction);
        this.getActionRegistry().registerAction((IAction)zoomAdjustAction);
        this.addKeyHandler((IAction)zoomInAction);
        this.addKeyHandler((IAction)zoomOutAction);
        IFigure gridLayer = rootEditPart.getLayer("Grid Layer");
        gridLayer.setForegroundColor(Resources.GRID_COLOR);
        Object action = new ToggleGridAction(viewer);
        this.getActionRegistry().registerAction((IAction)action);
        action = new ChangeBackgroundColorAction((IWorkbenchPart)this, this.diagram);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new TooltipAction(this);
        this.getActionRegistry().registerAction((IAction)action);
        action = new LockEditAction(this);
        this.getActionRegistry().registerAction((IAction)action);
        action = new ExportToDBAction(this);
        this.getActionRegistry().registerAction((IAction)action);
        this.actionBarContributor = new ERDiagramActionBarContributor(this.zoomComboContributionItem);
    }

    private void initDragAndDrop(GraphicalViewer viewer) {
        ERDiagramTransferDragSourceListener dragSourceListener = new ERDiagramTransferDragSourceListener((EditPartViewer)viewer, (Transfer)TemplateTransfer.getInstance());
        viewer.addDragSourceListener((TransferDragSourceListener)dragSourceListener);
        ERDiagramTransferDropTargetListener dropTargetListener = new ERDiagramTransferDropTargetListener((EditPartViewer)viewer, (Transfer)TemplateTransfer.getInstance());
        viewer.addDropTargetListener((TransferDropTargetListener)dropTargetListener);
    }

    private void addKeyHandler(IAction action) {
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        service.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public ERDiagramActionBarContributor getActionBarContributor() {
        return this.actionBarContributor;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorPart editorPart = this.getSite().getPage().getActiveEditor();
        if (editorPart instanceof ERDiagramMultiPageEditor) {
            ERDiagramMultiPageEditor multiPageEditorPart = (ERDiagramMultiPageEditor)editorPart;
            if (((Object)((Object)this)).equals(multiPageEditorPart.getActiveEditor())) {
                this.updateActions(this.getSelectionActions());
            }
        } else {
            super.selectionChanged(part, selection);
        }
    }

    public Point getLocation() {
        FigureCanvas canvas = (FigureCanvas)this.getGraphicalViewer().getControl();
        return canvas.getViewport().getViewLocation();
    }

    public void setLocation(int x, int y) {
        FigureCanvas canvas = (FigureCanvas)this.getGraphicalViewer().getControl();
        canvas.scrollTo(x, y);
    }

    public Object getMarkedObject(IMarker marker) {
        return this.markedObjectMap.get(marker);
    }

    public void setMarkedObject(IMarker marker, Object markedObject) {
        this.markedObjectMap.put(marker, markedObject);
    }

    public void clearMarkedObject() {
        this.markedObjectMap.clear();
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        return super.isDirty();
    }

    public String getProjectFilePath(String extention) {
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        String filePath = file.getLocation().toOSString();
        filePath = String.valueOf(filePath.substring(0, filePath.lastIndexOf("."))) + extention;
        return filePath;
    }
}

