/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.ERDiagramElementStateListener;
import org.insightech.er.editor.controller.command.category.ChangeCategoryNameCommand;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPartFactory;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.ddl.validator.ValidateResult;
import org.insightech.er.editor.model.dbexport.ddl.validator.Validator;
import org.insightech.er.editor.model.diagram_contents.element.node.category.Category;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.editor.model.diagram_contents.element.node.view.View;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;
import org.insightech.er.editor.model.diagram_contents.not_element.trigger.Trigger;
import org.insightech.er.editor.model.settings.CategorySetting;
import org.insightech.er.editor.persistent.Persistent;
import org.insightech.er.editor.view.dialog.category.CategoryNameChangeDialog;
import org.insightech.er.editor.view.outline.ERDiagramOutlinePage;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERDiagramMultiPageEditor
extends MultiPageEditorPart {
    private ERDiagram diagram;
    private ERDiagramEditPartFactory editPartFactory;
    private ZoomComboContributionItem zoomComboContributionItem;
    private ERDiagramOutlinePage outlinePage;
    private ERDiagramElementStateListener fElementStateListener;

    protected void createPages() {
        try {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            this.setPartName(file.getName());
            Persistent persistent = Persistent.getInstance();
            if (!file.isSynchronized(1)) {
                file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            InputStream in = file.getContents();
            this.diagram = persistent.load(in);
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
        if (this.diagram == null) {
            this.diagram = new ERDiagram(DBManagerFactory.getAllDBList().get(0));
            this.diagram.init();
        }
        this.diagram.getDiagramContents().getSettings().getTranslationSetting().load();
        this.diagram.setEditor(this);
        this.editPartFactory = new ERDiagramEditPartFactory();
        this.outlinePage = new ERDiagramOutlinePage(this.diagram);
        try {
            this.zoomComboContributionItem = new ZoomComboContributionItem((IPartService)this.getSite().getPage());
            ERDiagramEditor editor = new ERDiagramEditor(this.diagram, this.editPartFactory, this.zoomComboContributionItem, this.outlinePage);
            int index = this.addPage((IEditorPart)editor, this.getEditorInput());
            this.setPageText(index, ResourceString.getResourceString("label.all"));
        }
        catch (PartInitException e) {
            Activator.showExceptionDialog(e);
        }
        this.initCategoryPages();
        this.initStartPage();
        this.addMouseListenerToTabFolder();
        this.validate();
    }

    private void initStartPage() {
        int categoryIndex = this.diagram.getCurrentCategoryIndex();
        this.setActivePage(categoryIndex);
        if (categoryIndex > 0) {
            this.pageChange(categoryIndex);
        }
        ERDiagramEditor activeEditor = (ERDiagramEditor)this.getActiveEditor();
        ZoomManager zoomManager = (ZoomManager)activeEditor.getAdapter(ZoomManager.class);
        zoomManager.setZoom(this.diagram.getZoom());
        activeEditor.setLocation(this.diagram.getX(), this.diagram.getY());
    }

    protected Composite createPageContainer(Composite parent) {
        try {
            IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
            if (page != null) {
                page.showView("org.eclipse.ui.views.ContentOutline");
            }
        }
        catch (PartInitException e) {
            Activator.showExceptionDialog(e);
        }
        return super.createPageContainer(parent);
    }

    public void initCategoryPages() {
        CategorySetting categorySettings = this.diagram.getDiagramContents().getSettings().getCategorySetting();
        List<Category> selectedCategories = categorySettings.getSelectedCategories();
        if (this.getPageCount() > selectedCategories.size() + 1) {
            while (this.getPageCount() > selectedCategories.size() + 1) {
                IEditorPart editorPart = this.getEditor(selectedCategories.size() + 1);
                editorPart.dispose();
                this.removePage(selectedCategories.size() + 1);
            }
        }
        try {
            Category category;
            int i = 1;
            while (i < this.getPageCount()) {
                category = selectedCategories.get(i - 1);
                this.setPageText(i, Format.null2blank(category.getName()));
                ++i;
            }
            i = this.getPageCount();
            while (i < selectedCategories.size() + 1) {
                category = selectedCategories.get(i - 1);
                ERDiagramEditor diagramEditor = new ERDiagramEditor(this.diagram, this.editPartFactory, this.zoomComboContributionItem, this.outlinePage);
                this.addPage((IEditorPart)diagramEditor, this.getEditorInput());
                this.setPageText(i, Format.null2blank(category.getName()));
                ++i;
            }
        }
        catch (PartInitException e) {
            Activator.showExceptionDialog(e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        ZoomManager zoomManager = (ZoomManager)this.getActiveEditor().getAdapter(ZoomManager.class);
        double zoom = zoomManager.getZoom();
        this.diagram.setZoom(zoom);
        ERDiagramEditor activeEditor = (ERDiagramEditor)this.getActiveEditor();
        Point location = activeEditor.getLocation();
        this.diagram.setLocation(location.x, location.y);
        Persistent persistent = Persistent.getInstance();
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        try {
            this.diagram.getDiagramContents().getSettings().getModelProperties().setUpdatedDate(new Date());
            InputStream source = persistent.createInputStream(this.diagram);
            if (!file.exists()) {
                file.create(source, true, monitor);
            } else {
                file.setContents(source, true, false, monitor);
            }
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
        int i = 0;
        while (i < this.getPageCount()) {
            IEditorPart editor = this.getEditor(i);
            editor.doSave(monitor);
            ++i;
        }
        this.validate();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        int i = 0;
        while (i < this.getPageCount()) {
            ERDiagramEditor editor = (ERDiagramEditor)this.getEditor(i);
            editor.removeSelection();
            ++i;
        }
        ERDiagramEditor selectedEditor = (ERDiagramEditor)this.getActiveEditor();
        selectedEditor.changeCategory();
        Category category = this.getCurrentPageCategory();
        this.diagram.setCurrentCategory(category, newPageIndex);
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public Category getCurrentPageCategory() {
        List<Category> categories = this.diagram.getDiagramContents().getSettings().getCategorySetting().getSelectedCategories();
        int page = this.getActivePage();
        if (page == 0) {
            return null;
        }
        return categories.get(page - 1);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.fElementStateListener = new ERDiagramElementStateListener(this);
    }

    public void dispose() {
        this.fElementStateListener.disposeDocumentProvider();
        super.dispose();
    }

    protected void setInputWithNotify(IEditorInput input) {
        super.setInputWithNotify(input);
    }

    private void validate() {
        final IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        if (this.diagram.getDiagramContents().getSettings().isSuspendValidator()) {
            try {
                file.deleteMarkers(null, true, 2);
            }
            catch (CoreException e) {
                Activator.showExceptionDialog(e);
            }
        } else {
            IWorkspaceRunnable editorMarker = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ERDiagramEditor editor = (ERDiagramEditor)ERDiagramMultiPageEditor.this.getActiveEditor();
                    file.deleteMarkers(null, true, 2);
                    editor.clearMarkedObject();
                    Validator validator = new Validator();
                    List<ValidateResult> errorList = validator.validate(ERDiagramMultiPageEditor.this.diagram);
                    for (ValidateResult error : errorList) {
                        IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
                        marker.setAttribute("message", (Object)error.getMessage());
                        marker.setAttribute("transient", true);
                        marker.setAttribute("location", (Object)error.getLocation());
                        marker.setAttribute("severity", error.getSeverity());
                        editor.setMarkedObject(marker, error.getObject());
                    }
                    List todoList = ERDiagramMultiPageEditor.this.validateTodo();
                    for (ValidateResult todo : todoList) {
                        IMarker marker = file.createMarker("org.eclipse.core.resources.taskmarker");
                        marker.setAttribute("message", (Object)todo.getMessage());
                        marker.setAttribute("transient", true);
                        marker.setAttribute("location", (Object)todo.getLocation());
                        marker.setAttribute("severity", todo.getSeverity());
                        editor.setMarkedObject(marker, todo.getObject());
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(editorMarker, null);
            }
            catch (CoreException e) {
                Activator.showExceptionDialog(e);
            }
        }
    }

    private List<ValidateResult> validateTodo() {
        String description;
        ArrayList<ValidateResult> resultList = new ArrayList<ValidateResult>();
        for (ERTable table : this.diagram.getDiagramContents().getContents().getTableSet()) {
            description = table.getDescription();
            resultList.addAll(this.createTodo(description, table.getLogicalName(), table));
            for (NormalColumn column : table.getNormalColumns()) {
                description = column.getDescription();
                resultList.addAll(this.createTodo(description, table.getLogicalName(), table));
            }
            for (Index index : table.getIndexes()) {
                description = index.getDescription();
                resultList.addAll(this.createTodo(description, index.getName(), index));
            }
        }
        for (View view : this.diagram.getDiagramContents().getContents().getViewSet().getList()) {
            description = view.getDescription();
            resultList.addAll(this.createTodo(description, view.getName(), view));
            for (NormalColumn column : view.getNormalColumns()) {
                description = column.getDescription();
                resultList.addAll(this.createTodo(description, view.getLogicalName(), view));
            }
        }
        for (Trigger trigger : this.diagram.getDiagramContents().getTriggerSet().getTriggerList()) {
            description = trigger.getDescription();
            resultList.addAll(this.createTodo(description, trigger.getName(), trigger));
        }
        for (Sequence sequence : this.diagram.getDiagramContents().getSequenceSet().getSequenceList()) {
            description = sequence.getDescription();
            resultList.addAll(this.createTodo(description, sequence.getName(), sequence));
        }
        return resultList;
    }

    private List<ValidateResult> createTodo(String description, String location, Object object) {
        ArrayList<ValidateResult> resultList = new ArrayList<ValidateResult>();
        if (description != null) {
            StringTokenizer tokenizer = new StringTokenizer(description, "\n\r");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                int startIndex = token.indexOf("// TODO");
                if (startIndex == -1) continue;
                String message = token.substring(startIndex + "// TODO".length()).trim();
                ValidateResult result = new ValidateResult();
                result.setLocation(location);
                result.setMessage(message);
                result.setObject(object);
                resultList.add(result);
            }
        }
        return resultList;
    }

    public void setCurrentCategoryPageName() {
        Category category = this.getCurrentPageCategory();
        this.setPageText(this.getActivePage(), Format.null2blank(category.getName()));
    }

    private void addMouseListenerToTabFolder() {
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseevent) {
                CategoryNameChangeDialog dialog;
                Category category = ERDiagramMultiPageEditor.this.getCurrentPageCategory();
                if (category != null && (dialog = new CategoryNameChangeDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), category)).open() == 0) {
                    ChangeCategoryNameCommand command = new ChangeCategoryNameCommand(ERDiagramMultiPageEditor.this.diagram, category, dialog.getCategoryName());
                    ERDiagramMultiPageEditor.this.execute(command);
                }
                super.mouseDoubleClick(mouseevent);
            }
        });
    }

    private void execute(Command command) {
        ERDiagramEditor selectedEditor = (ERDiagramEditor)this.getActiveEditor();
        selectedEditor.getGraphicalViewer().getEditDomain().getCommandStack().execute(command);
    }

    public Object getAdapter(Class type) {
        if (type == ERDiagram.class) {
            return this.diagram;
        }
        return super.getAdapter(type);
    }
}

