/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.command.common;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.controller.command.AbstractCommand;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.Location;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeSet;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.GroupSet;

public class PasteCommand
extends AbstractCommand {
    private ERDiagram diagram;
    private GraphicalViewer viewer;
    private NodeSet nodeElements;
    private GroupSet columnGroups;

    public PasteCommand(ERDiagramEditor editor, NodeSet nodeElements, int x, int y) {
        this.viewer = editor.getGraphicalViewer();
        this.diagram = (ERDiagram)this.viewer.getContents().getModel();
        this.nodeElements = nodeElements;
        this.columnGroups = new GroupSet();
        for (NodeElement nodeElement : nodeElements) {
            nodeElement.setLocation(new Location(nodeElement.getX() + x, nodeElement.getY() + y, nodeElement.getWidth(), nodeElement.getHeight()));
            if (!(nodeElement instanceof ERTable)) continue;
            ERTable table = (ERTable)nodeElement;
            for (Column column : table.getColumns()) {
                if (!(column instanceof ColumnGroup)) continue;
                ColumnGroup group = (ColumnGroup)column;
                if (this.diagram.getDiagramContents().getGroups().contains(group)) continue;
                this.columnGroups.add(group);
            }
        }
    }

    protected void doExecute() {
        ERDiagramEditPart.setUpdateable(false);
        GroupSet columnGroupSet = this.diagram.getDiagramContents().getGroups();
        for (NodeElement nodeElement : this.nodeElements) {
            this.diagram.addContent(nodeElement);
        }
        for (ColumnGroup columnGroup : this.columnGroups) {
            columnGroupSet.add(columnGroup);
        }
        ERDiagramEditPart.setUpdateable(true);
        this.diagram.changeAll();
        this.setFocus();
    }

    protected void doUndo() {
        ERDiagramEditPart.setUpdateable(false);
        GroupSet columnGroupSet = this.diagram.getDiagramContents().getGroups();
        for (NodeElement nodeElement : this.nodeElements) {
            this.diagram.removeContent(nodeElement);
        }
        for (ColumnGroup columnGroup : this.columnGroups) {
            columnGroupSet.remove(columnGroup);
        }
        ERDiagramEditPart.setUpdateable(true);
        this.diagram.changeAll();
    }

    private void setFocus() {
        for (NodeElement nodeElement : this.nodeElements) {
            EditPart editPart = (EditPart)this.viewer.getEditPartRegistry().get(nodeElement);
            this.viewer.getSelectionManager().appendSelection(editPart);
        }
    }
}

