/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation.AbstractCreateRelationCommand;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.TableView;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Word;
import org.insightech.er.editor.view.dialog.element.relation.RelationByExistingColumnsDialog;

public class CreateRelationByExistingColumnsCommand
extends AbstractCreateRelationCommand {
    private Relation relation;
    private List<NormalColumn> referencedColumnList;
    private List<NormalColumn> foreignKeyColumnList;
    private List<Word> wordList = new ArrayList<Word>();

    protected void doExecute() {
        ERTable sourceTable = (ERTable)this.source.getModel();
        TableView targetTable = (TableView)this.target.getModel();
        this.relation.setSource(sourceTable);
        this.relation.setTargetWithoutForeignKey(targetTable);
        int i = 0;
        while (i < this.foreignKeyColumnList.size()) {
            NormalColumn foreignKeyColumn = this.foreignKeyColumnList.get(i);
            this.wordList.add(foreignKeyColumn.getWord());
            sourceTable.getDiagram().getDiagramContents().getDictionary().remove(foreignKeyColumn);
            foreignKeyColumn.addReference(this.referencedColumnList.get(i), this.relation);
            foreignKeyColumn.setWord(null);
            ++i;
        }
        targetTable.setDirty();
    }

    protected void doUndo() {
        ERTable sourceTable = (ERTable)this.source.getModel();
        ERTable targetTable = (ERTable)this.target.getModel();
        this.relation.setSource(null);
        this.relation.setTargetWithoutForeignKey(null);
        int i = 0;
        while (i < this.foreignKeyColumnList.size()) {
            NormalColumn foreignKeyColumn = this.foreignKeyColumnList.get(i);
            foreignKeyColumn.removeReference(this.relation);
            foreignKeyColumn.setWord(this.wordList.get(i));
            sourceTable.getDiagram().getDiagramContents().getDictionary().add(foreignKeyColumn);
            ++i;
        }
        targetTable.setDirty();
    }

    public boolean selectColumns() {
        if (this.target == null) {
            return false;
        }
        ERTable sourceTable = (ERTable)this.source.getModel();
        TableView targetTable = (TableView)this.target.getModel();
        HashMap<NormalColumn, List<NormalColumn>> referencedMap = new HashMap<NormalColumn, List<NormalColumn>>();
        HashMap<Relation, Set<NormalColumn>> foreignKeySetMap = new HashMap<Relation, Set<NormalColumn>>();
        for (NormalColumn normalColumn : targetTable.getNormalColumns()) {
            NormalColumn rootReferencedColumn = normalColumn.getRootReferencedColumn();
            if (rootReferencedColumn == null) continue;
            ArrayList<NormalColumn> foreignKeyList = (ArrayList<NormalColumn>)referencedMap.get(rootReferencedColumn);
            if (foreignKeyList == null) {
                foreignKeyList = new ArrayList<NormalColumn>();
                referencedMap.put(rootReferencedColumn, foreignKeyList);
            }
            foreignKeyList.add(normalColumn);
            for (Relation relation : normalColumn.getRelationList()) {
                HashSet<NormalColumn> foreignKeySet = (HashSet<NormalColumn>)foreignKeySetMap.get(relation);
                if (foreignKeySet == null) {
                    foreignKeySet = new HashSet<NormalColumn>();
                    foreignKeySetMap.put(relation, foreignKeySet);
                }
                foreignKeySet.add(normalColumn);
            }
        }
        ArrayList<NormalColumn> candidateForeignKeyColumns = new ArrayList<NormalColumn>();
        for (NormalColumn column : targetTable.getNormalColumns()) {
            if (column.isForeignKey()) continue;
            candidateForeignKeyColumns.add(column);
        }
        if (candidateForeignKeyColumns.isEmpty()) {
            Activator.showErrorDialog("error.no.candidate.of.foreign.key.exist");
            return false;
        }
        RelationByExistingColumnsDialog dialog = new RelationByExistingColumnsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), sourceTable, candidateForeignKeyColumns, referencedMap, foreignKeySetMap);
        if (dialog.open() != 0) {
            return false;
        }
        this.relation = new Relation(dialog.isReferenceForPK(), dialog.getReferencedComplexUniqueKey(), dialog.getReferencedColumn());
        this.referencedColumnList = dialog.getReferencedColumnList();
        this.foreignKeyColumnList = dialog.getForeignKeyColumnList();
        return true;
    }
}

