/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.command.tracking;

import java.util.List;
import org.insightech.er.editor.controller.command.AbstractCommand;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeSet;
import org.insightech.er.editor.model.tracking.ChangeTrackingList;
import org.insightech.er.editor.model.tracking.RemovedNodeElement;
import org.insightech.er.editor.model.tracking.UpdatedNodeElement;

public class CalculateChangeTrackingCommand
extends AbstractCommand {
    private ERDiagram diagram;
    private NodeSet comparison;
    private ChangeTrackingList changeTrackingList;
    private List<NodeElement> oldAddedNodeElements;
    private List<UpdatedNodeElement> oldUpdatedNodeElements;
    private List<RemovedNodeElement> oldRemovedNodeElements;

    public CalculateChangeTrackingCommand(ERDiagram diagram, NodeSet comparison) {
        this.diagram = diagram;
        this.comparison = comparison;
        this.changeTrackingList = this.diagram.getChangeTrackingList();
        this.oldAddedNodeElements = this.changeTrackingList.getAddedNodeElementSet();
        this.oldUpdatedNodeElements = this.changeTrackingList.getUpdatedNodeElementSet();
        this.oldRemovedNodeElements = this.changeTrackingList.getRemovedNodeElementSet();
    }

    protected void doExecute() {
        this.changeTrackingList.calculateUpdatedNodeElementSet(this.comparison, this.diagram.getDiagramContents().getContents());
        this.diagram.changeAll();
    }

    protected void doUndo() {
        this.changeTrackingList.restore(this.oldAddedNodeElements, this.oldUpdatedNodeElements, this.oldRemovedNodeElements);
        this.diagram.changeAll();
    }
}

