/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.element;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.swt.graphics.Color;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.settings.PageSetting;

public class PagableFreeformRootEditPart
extends ScalableFreeformRootEditPart {
    private ERDiagram diagram;

    public PagableFreeformRootEditPart(ERDiagram diagram) {
        this.diagram = diagram;
    }

    protected GridLayer createGridLayer() {
        return new PagableGridLayer();
    }

    private class PagableGridLayer
    extends GridLayer {
        private int i = 0;

        private PagableGridLayer() {
        }

        protected void paintGrid(Graphics g) {
            int startY;
            super.paintGrid(g);
            Rectangle clip = g.getClip(Rectangle.SINGLETON);
            PageSetting pageSetting = PagableFreeformRootEditPart.this.diagram.getPageSetting();
            int width = pageSetting.getWidth();
            int height = pageSetting.getHeight();
            Rectangle rect = clip;
            Color color = g.getForegroundColor();
            g.setForegroundColor(ColorConstants.lightGray);
            int startX = rect.x;
            if (startX > 0) {
                startX = 0;
            }
            if ((startY = rect.y) > 0) {
                startY = 0;
            }
            int i = startX;
            while (i < rect.x + rect.width) {
                g.drawLine(i, rect.y, i, rect.y + rect.height);
                i += width;
            }
            i = startY;
            while (i < rect.y + rect.height) {
                g.drawLine(rect.x, i, rect.x + rect.width, i);
                i += height;
            }
            g.setForegroundColor(color);
            ++this.i;
            if (this.i > 0) {
                this.i = -1;
                this.repaint();
            }
        }
    }
}

