/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.element.connection;

import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation.ChangeRelationPropertyCommand;
import org.insightech.er.editor.controller.editpart.element.connection.ERDiagramConnectionEditPart;
import org.insightech.er.editor.controller.editpart.element.node.ERTableEditPart;
import org.insightech.er.editor.controller.editpart.element.node.TableViewEditPart;
import org.insightech.er.editor.controller.editpolicy.element.connection.RelationBendpointEditPolicy;
import org.insightech.er.editor.controller.editpolicy.element.connection.RelationEditPolicy;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.connection.Bendpoint;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.view.dialog.element.relation.RelationDialog;
import org.insightech.er.editor.view.figure.anchor.XYChopboxAnchor;
import org.insightech.er.editor.view.figure.connection.ERDiagramConnection;
import org.insightech.er.editor.view.figure.connection.decoration.DecorationFactory;
import org.insightech.er.util.Format;

public class RelationEditPart
extends ERDiagramConnectionEditPart {
    private Label targetLabel;

    protected IFigure createFigure() {
        boolean bezier = this.getDiagram().getDiagramContents().getSettings().isUseBezierCurve();
        ERDiagramConnection connection = new ERDiagramConnection(bezier);
        connection.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        ConnectionEndpointLocator targetLocator = new ConnectionEndpointLocator((Connection)connection, true);
        this.targetLabel = new Label("");
        connection.add((IFigure)this.targetLabel, targetLocator);
        return connection;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new RelationEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new RelationBendpointEditPolicy());
    }

    protected void refreshBendpoints() {
        try {
            Relation relation = (Relation)this.getModel();
            ArrayList<Object> constraint = new ArrayList<Object>();
            for (Bendpoint bendPoint : relation.getBendpoints()) {
                if (bendPoint.isRelative()) {
                    ERTableEditPart tableEditPart = (ERTableEditPart)this.getSource();
                    if (tableEditPart == null) continue;
                    Rectangle bounds = tableEditPart.getFigure().getBounds();
                    int width = bounds.width;
                    int height = bounds.height;
                    if (width == 0) {
                        bounds = tableEditPart.getFigure().getBounds();
                        width = bounds.width;
                        height = bounds.height;
                    }
                    RelativeBendpoint point = new RelativeBendpoint();
                    int xp = relation.getTargetXp();
                    int x = xp == -1 ? bounds.x + bounds.width : bounds.x + bounds.width * xp / 100;
                    point.setRelativeDimensions(new Dimension(width * bendPoint.getX() / 100 - bounds.x - bounds.width + x, 0), new Dimension(width * bendPoint.getX() / 100 - bounds.x - bounds.width + x, 0));
                    point.setWeight(0.0f);
                    point.setConnection(this.getConnectionFigure());
                    constraint.add(point);
                    point = new RelativeBendpoint();
                    point.setRelativeDimensions(new Dimension(width * bendPoint.getX() / 100 - bounds.x - bounds.width + x, height * bendPoint.getY() / 100), new Dimension(width * bendPoint.getX() / 100 - bounds.x - bounds.width + x, height * bendPoint.getY() / 100));
                    point.setWeight(0.0f);
                    point.setConnection(this.getConnectionFigure());
                    constraint.add(point);
                    point = new RelativeBendpoint();
                    point.setRelativeDimensions(new Dimension(x - bounds.x - bounds.width, height * bendPoint.getY() / 100), new Dimension(x - bounds.x - bounds.width, height * bendPoint.getY() / 100));
                    point.setWeight(0.0f);
                    point.setConnection(this.getConnectionFigure());
                    constraint.add(point);
                    continue;
                }
                constraint.add(new AbsoluteBendpoint(bendPoint.getX(), bendPoint.getY()));
            }
            this.getConnectionFigure().setRoutingConstraint(constraint);
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        ERDiagram diagram = this.getDiagram();
        if (diagram != null) {
            Relation relation = (Relation)this.getModel();
            PolylineConnection connection = (PolylineConnection)this.getConnectionFigure();
            String notation = diagram.getDiagramContents().getSettings().getNotation();
            DecorationFactory.Decoration decoration = DecorationFactory.getDecoration(notation, relation.getParentCardinality(), relation.getChildCardinality());
            connection.setSourceDecoration(decoration.getSourceDecoration());
            connection.setTargetDecoration(decoration.getTargetDecoration());
            this.targetLabel.setText(Format.null2blank(decoration.getTargetLabel()));
        }
        this.calculateAnchorLocation();
        this.refreshBendpoints();
    }

    public void performRequest(Request request) {
        Relation relation = (Relation)this.getModel();
        if (request.getType().equals("open")) {
            Relation copy = relation.copy();
            RelationDialog dialog = new RelationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), copy);
            if (dialog.open() == 0) {
                ChangeRelationPropertyCommand command = new ChangeRelationPropertyCommand(relation, copy);
                this.getViewer().getEditDomain().getCommandStack().execute((Command)command);
            }
        }
        super.performRequest(request);
    }

    private void calculateAnchorLocation() {
        ConnectionAnchor targetAnchor;
        ConnectionAnchor sourceAnchor;
        TableViewEditPart targetEditPart;
        Relation relation = (Relation)this.getModel();
        TableViewEditPart sourceEditPart = (TableViewEditPart)this.getSource();
        Point sourcePoint = null;
        Point targetPoint = null;
        if (sourceEditPart != null && relation.getSourceXp() != -1 && relation.getSourceYp() != -1) {
            Rectangle bounds = sourceEditPart.getFigure().getBounds();
            sourcePoint = new Point(bounds.x + bounds.width * relation.getSourceXp() / 100, bounds.y + bounds.height * relation.getSourceYp() / 100);
        }
        if ((targetEditPart = (TableViewEditPart)this.getTarget()) != null && relation.getTargetXp() != -1 && relation.getTargetYp() != -1) {
            Rectangle bounds = targetEditPart.getFigure().getBounds();
            targetPoint = new Point(bounds.x + bounds.width * relation.getTargetXp() / 100, bounds.y + bounds.height * relation.getTargetYp() / 100);
        }
        if ((sourceAnchor = this.getConnectionFigure().getSourceAnchor()) instanceof XYChopboxAnchor) {
            ((XYChopboxAnchor)sourceAnchor).setLocation(sourcePoint);
        }
        if ((targetAnchor = this.getConnectionFigure().getTargetAnchor()) instanceof XYChopboxAnchor) {
            ((XYChopboxAnchor)targetAnchor).setLocation(targetPoint);
        }
    }
}

