/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.element.node;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.editor.controller.command.diagram_contents.element.node.table_view.ChangeTableViewPropertyCommand;
import org.insightech.er.editor.controller.command.diagram_contents.not_element.sequence.CreateSequenceCommand;
import org.insightech.er.editor.controller.command.diagram_contents.not_element.sequence.DeleteSequenceCommand;
import org.insightech.er.editor.controller.command.diagram_contents.not_element.trigger.CreateTriggerCommand;
import org.insightech.er.editor.controller.command.diagram_contents.not_element.trigger.DeleteTriggerCommand;
import org.insightech.er.editor.controller.editpart.element.node.IResizable;
import org.insightech.er.editor.controller.editpart.element.node.TableViewEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.CopyColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.SequenceSet;
import org.insightech.er.editor.model.diagram_contents.not_element.trigger.Trigger;
import org.insightech.er.editor.model.diagram_contents.not_element.trigger.TriggerSet;
import org.insightech.er.editor.model.settings.Settings;
import org.insightech.er.editor.view.dialog.element.table.TableDialog;
import org.insightech.er.editor.view.figure.table.TableFigure;
import org.insightech.er.util.Check;

public class ERTableEditPart
extends TableViewEditPart
implements IResizable {
    protected IFigure createFigure() {
        ERDiagram diagram = this.getDiagram();
        Settings settings = diagram.getDiagramContents().getSettings();
        TableFigure figure = new TableFigure(settings.getTableStyle());
        this.changeFont(figure);
        return figure;
    }

    public void performRequestOpen() {
        ERTable table = (ERTable)this.getModel();
        ERDiagram diagram = this.getDiagram();
        ERTable copyTable = table.copyData();
        TableDialog dialog = new TableDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getViewer(), copyTable, diagram.getDiagramContents().getGroups());
        if (dialog.open() == 0) {
            CompoundCommand command = ERTableEditPart.createChangeTablePropertyCommand(diagram, table, copyTable);
            this.executeCommand(command.unwrap());
        }
    }

    public static CompoundCommand createChangeTablePropertyCommand(ERDiagram diagram, ERTable table, ERTable copyTable) {
        CompoundCommand command = new CompoundCommand();
        ChangeTableViewPropertyCommand changeTablePropertyCommand = new ChangeTableViewPropertyCommand(table, copyTable);
        command.add((Command)changeTablePropertyCommand);
        String tableName = copyTable.getPhysicalName();
        if ("Oracle".equals(diagram.getDatabase()) && !Check.isEmpty(tableName)) {
            NormalColumn oldAutoIncrementColumn;
            String columnName;
            NormalColumn autoIncrementColumn = copyTable.getAutoIncrementColumn();
            if (autoIncrementColumn != null && !Check.isEmpty(columnName = autoIncrementColumn.getPhysicalName())) {
                String triggerName = "TRI_" + tableName + "_" + columnName;
                String sequenceName = "SEQ_" + tableName + "_" + columnName;
                TriggerSet triggerSet = diagram.getDiagramContents().getTriggerSet();
                SequenceSet sequenceSet = diagram.getDiagramContents().getSequenceSet();
                if (!(triggerSet.contains(triggerName) && sequenceSet.contains(sequenceName) || !Activator.showConfirmDialog("dialog.message.confirm.create.autoincrement.trigger"))) {
                    if (!triggerSet.contains(triggerName)) {
                        Trigger trigger = new Trigger();
                        trigger.setName(triggerName);
                        trigger.setSql("BEFORE INSERT ON " + tableName + "\r\nFOR EACH ROW" + "\r\nBEGIN" + "\r\n\tSELECT " + sequenceName + ".nextval\r\n\tINTO :new." + columnName + "\r\n\tFROM dual;" + "\r\nEND");
                        CreateTriggerCommand createTriggerCommand = new CreateTriggerCommand(diagram, trigger);
                        command.add((Command)createTriggerCommand);
                    }
                    if (!sequenceSet.contains(sequenceName)) {
                        Sequence sequence = new Sequence();
                        sequence.setName(sequenceName);
                        sequence.setStart(1L);
                        sequence.setIncrement(1);
                        CreateSequenceCommand createSequenceCommand = new CreateSequenceCommand(diagram, sequence);
                        command.add((Command)createSequenceCommand);
                    }
                }
            }
            if ((oldAutoIncrementColumn = table.getAutoIncrementColumn()) != null && (autoIncrementColumn == null || ((CopyColumn)autoIncrementColumn).getOriginalColumn() != oldAutoIncrementColumn)) {
                String oldTableName = table.getPhysicalName();
                String columnName2 = oldAutoIncrementColumn.getPhysicalName();
                if (!Check.isEmpty(columnName2)) {
                    String triggerName = "TRI_" + oldTableName + "_" + columnName2;
                    String sequenceName = "SEQ_" + oldTableName + "_" + columnName2;
                    TriggerSet triggerSet = diagram.getDiagramContents().getTriggerSet();
                    SequenceSet sequenceSet = diagram.getDiagramContents().getSequenceSet();
                    if ((triggerSet.contains(triggerName) || sequenceSet.contains(sequenceName)) && Activator.showConfirmDialog("dialog.message.confirm.remove.autoincrement.trigger")) {
                        Sequence sequence;
                        Trigger trigger = triggerSet.get(triggerName);
                        if (trigger != null) {
                            DeleteTriggerCommand deleteTriggerCommand = new DeleteTriggerCommand(diagram, trigger);
                            command.add((Command)deleteTriggerCommand);
                        }
                        if ((sequence = sequenceSet.get(sequenceName)) != null) {
                            DeleteSequenceCommand deleteSequenceCommand = new DeleteSequenceCommand(diagram, sequence);
                            command.add((Command)deleteSequenceCommand);
                        }
                    }
                }
            }
        }
        return command;
    }
}

