/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.element.node;

import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.editor.controller.command.diagram_contents.element.node.image.ChangeInsertedImagePropertyCommand;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPart;
import org.insightech.er.editor.controller.editpart.element.node.IResizable;
import org.insightech.er.editor.controller.editpart.element.node.NodeElementEditPart;
import org.insightech.er.editor.controller.editpolicy.element.node.NodeElementComponentEditPolicy;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.image.InsertedImage;
import org.insightech.er.editor.view.dialog.element.InsertedImageDialog;
import org.insightech.er.editor.view.figure.InsertedImageFigure;

public class InsertedImageEditPart
extends NodeElementEditPart
implements IResizable {
    private Image image;
    private ImageData imageData;

    protected IFigure createFigure() {
        InsertedImage model = (InsertedImage)this.getModel();
        byte[] data = Base64.decodeBase64((byte[])model.getBase64EncodedData().getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        this.imageData = new ImageData((InputStream)in);
        this.changeImage();
        InsertedImageFigure figure = new InsertedImageFigure(this.image, model.isFixAspectRatio(), model.getAlpha());
        figure.setMinimumSize(new Dimension(1, 1));
        return figure;
    }

    protected void disposeFont() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        super.disposeFont();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NodeElementComponentEditPolicy());
        super.createEditPolicies();
    }

    public void doPropertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("image")) {
            this.changeImage();
            InsertedImageFigure figure = (InsertedImageFigure)this.getFigure();
            InsertedImage model = (InsertedImage)this.getModel();
            figure.setImg(this.image, model.isFixAspectRatio(), model.getAlpha());
            this.refreshVisuals();
            if (ERDiagramEditPart.isUpdateable()) {
                this.getFigure().repaint();
            }
        }
        super.doPropertyChange(event);
    }

    private void changeImage() {
        InsertedImage model = (InsertedImage)this.getModel();
        ImageData newImageData = new ImageData(this.imageData.width, this.imageData.height, this.imageData.depth, this.imageData.palette);
        int x = 0;
        while (x < this.imageData.width) {
            int y = 0;
            while (y < this.imageData.height) {
                RGB rgb = this.imageData.palette.getRGB(this.imageData.getPixel(x, y));
                float[] hsb = rgb.getHSB();
                if (model.getHue() != 0) {
                    hsb[0] = model.getHue() & 0x168;
                }
                hsb[1] = hsb[1] + (float)model.getSaturation() / 100.0f;
                if (hsb[1] > 1.0f) {
                    hsb[1] = 1.0f;
                } else if (hsb[1] < 0.0f) {
                    hsb[1] = 0.0f;
                }
                hsb[2] = hsb[2] + (float)model.getBrightness() / 100.0f;
                if (hsb[2] > 1.0f) {
                    hsb[2] = 1.0f;
                } else if (hsb[2] < 0.0f) {
                    hsb[2] = 0.0f;
                }
                RGB newRGB = new RGB(hsb[0], hsb[1], hsb[2]);
                int pixel = this.imageData.palette.getPixel(newRGB);
                newImageData.setPixel(x, y, pixel);
                ++y;
            }
            ++x;
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = new Image((Device)Display.getDefault(), newImageData);
    }

    public void performRequestOpen() {
        InsertedImage insertedImage = (InsertedImage)this.getModel();
        InsertedImage oldInsertedImage = (InsertedImage)insertedImage.clone();
        ERDiagram diagram = this.getDiagram();
        InsertedImageDialog dialog = new InsertedImageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), insertedImage);
        if (dialog.open() == 0) {
            ChangeInsertedImagePropertyCommand command = new ChangeInsertedImagePropertyCommand(diagram, insertedImage, dialog.getNewInsertedImage(), oldInsertedImage);
            this.executeCommand(command);
        } else {
            ChangeInsertedImagePropertyCommand command = new ChangeInsertedImagePropertyCommand(diagram, insertedImage, oldInsertedImage, oldInsertedImage);
            command.execute();
        }
    }
}

