/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.element.node;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.insightech.er.Activator;
import org.insightech.er.editor.controller.command.diagram_contents.element.connection.CreateCommentConnectionCommand;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPart;
import org.insightech.er.editor.controller.editpart.element.connection.RelationEditPart;
import org.insightech.er.editor.controller.editpart.element.node.IResizable;
import org.insightech.er.editor.controller.editpart.element.node.NodeElementEditPart;
import org.insightech.er.editor.controller.editpart.element.node.column.ColumnEditPart;
import org.insightech.er.editor.controller.editpart.element.node.column.GroupColumnEditPart;
import org.insightech.er.editor.controller.editpart.element.node.column.NormalColumnEditPart;
import org.insightech.er.editor.controller.editpolicy.element.node.table_view.TableViewComponentEditPolicy;
import org.insightech.er.editor.controller.editpolicy.element.node.table_view.TableViewGraphicalNodeEditPolicy;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.TableView;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.model.settings.Settings;
import org.insightech.er.editor.model.tracking.UpdatedNodeElement;
import org.insightech.er.editor.view.figure.anchor.XYChopboxAnchor;
import org.insightech.er.editor.view.figure.table.TableFigure;
import org.insightech.er.editor.view.figure.table.column.GroupColumnFigure;
import org.insightech.er.editor.view.figure.table.column.NormalColumnFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableViewEditPart
extends NodeElementEditPart
implements IResizable {
    private Font titleFont;

    protected List getModelChildren() {
        ArrayList<Column> modelChildren = new ArrayList<Column>();
        TableView tableView = (TableView)this.getModel();
        ERDiagram diagram = this.getDiagram();
        if (diagram.getDiagramContents().getSettings().isNotationExpandGroup()) {
            modelChildren.addAll(tableView.getExpandedColumns());
        } else {
            modelChildren.addAll(tableView.getColumns());
        }
        return modelChildren;
    }

    @Override
    public void doPropertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("table_view_physicalName")) {
            this.refreshVisuals();
        } else if (event.getPropertyName().equals("table_view_logicalName")) {
            this.refreshVisuals();
        } else if (event.getPropertyName().equals("columns")) {
            this.refreshChildren();
            this.refreshVisuals();
        }
        super.doPropertyChange(event);
        this.refreshConnections();
    }

    public void refresh() {
        super.refresh();
        this.refreshConnections();
    }

    @Override
    public void refreshVisuals() {
        try {
            TableFigure tableFigure = (TableFigure)this.getFigure();
            TableView tableView = (TableView)this.getModel();
            tableFigure.create(tableView.getColor());
            ERDiagram diagram = this.getDiagram();
            tableFigure.setName(TableViewEditPart.getTableViewName(tableView, diagram));
            UpdatedNodeElement updated = null;
            if (diagram.getChangeTrackingList().isCalculated()) {
                updated = diagram.getChangeTrackingList().getUpdatedNodeElement(tableView);
            }
            for (Object child : this.getChildren()) {
                ColumnEditPart part = (ColumnEditPart)child;
                part.refreshTableColumns(updated);
            }
            if (updated != null) {
                TableViewEditPart.showRemovedColumns(diagram, tableFigure, updated.getRemovedColumns(), true);
            }
            super.refreshVisuals();
            if (ERDiagramEditPart.isUpdateable()) {
                this.getFigure().getUpdateManager().performValidation();
            }
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
    }

    public static void showRemovedColumns(ERDiagram diagram, TableFigure tableFigure, Collection<Column> removedColumns, boolean isRemoved) {
        int notationLevel = diagram.getDiagramContents().getSettings().getNotationLevel();
        for (Column removedColumn : removedColumns) {
            if (removedColumn instanceof ColumnGroup) {
                if (diagram.getDiagramContents().getSettings().isNotationExpandGroup()) {
                    ColumnGroup columnGroup = (ColumnGroup)removedColumn;
                    for (NormalColumn normalColumn : columnGroup.getColumns()) {
                        if (notationLevel == 3 && !normalColumn.isPrimaryKey() && !normalColumn.isForeignKey() && !normalColumn.isReferedStrictly()) continue;
                        NormalColumnFigure columnFigure = new NormalColumnFigure();
                        tableFigure.getColumns().add((IFigure)columnFigure);
                        NormalColumnEditPart.addColumnFigure(diagram, tableFigure, columnFigure, normalColumn, false, false, false, false, isRemoved);
                    }
                    continue;
                }
                if (notationLevel == 3) continue;
                GroupColumnFigure columnFigure = new GroupColumnFigure();
                tableFigure.getColumns().add((IFigure)columnFigure);
                GroupColumnEditPart.addGroupColumnFigure(diagram, tableFigure, columnFigure, removedColumn, false, false, isRemoved);
                continue;
            }
            NormalColumn normalColumn = (NormalColumn)removedColumn;
            if (notationLevel == 3 && !normalColumn.isPrimaryKey() && !normalColumn.isForeignKey() && !normalColumn.isReferedStrictly()) continue;
            NormalColumnFigure columnFigure = new NormalColumnFigure();
            tableFigure.getColumns().add((IFigure)columnFigure);
            NormalColumnEditPart.addColumnFigure(diagram, tableFigure, columnFigure, normalColumn, false, false, false, false, isRemoved);
        }
    }

    @Override
    public void changeSettings(Settings settings) {
        TableFigure figure = (TableFigure)this.getFigure();
        figure.setTableStyle(settings.getTableStyle());
        super.changeSettings(settings);
    }

    @Override
    protected void disposeFont() {
        if (this.titleFont != null) {
            this.titleFont.dispose();
        }
        super.disposeFont();
    }

    protected Font changeFont(TableFigure tableFigure) {
        Font font = super.changeFont((IFigure)tableFigure);
        FontData fonData = font.getFontData()[0];
        this.titleFont = new Font((Device)Display.getCurrent(), fonData.getName(), fonData.getHeight(), 1);
        tableFigure.setFont(font, this.titleFont);
        return font;
    }

    public static String getTableViewName(TableView tableView, ERDiagram diagram) {
        String name = null;
        int viewMode = diagram.getDiagramContents().getSettings().getViewMode();
        name = viewMode == 1 ? diagram.filter(tableView.getPhysicalName()) : (viewMode == 0 ? diagram.filter(tableView.getLogicalName()) : String.valueOf(diagram.filter(tableView.getLogicalName())) + "/" + diagram.filter(tableView.getPhysicalName()));
        return name;
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart editPart) {
        if (!(editPart instanceof RelationEditPart)) {
            return super.getSourceConnectionAnchor(editPart);
        }
        Relation relation = (Relation)editPart.getModel();
        Rectangle bounds = this.getFigure().getBounds();
        XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure());
        if (relation.getSourceXp() != -1 && relation.getSourceYp() != -1) {
            anchor.setLocation(new Point(bounds.x + bounds.width * relation.getSourceXp() / 100, bounds.y + bounds.height * relation.getSourceYp() / 100));
        }
        return anchor;
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        CreateConnectionRequest connectionRequest;
        Command command;
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart connectionEditPart = reconnectRequest.getConnectionEditPart();
            if (!(connectionEditPart instanceof RelationEditPart)) {
                return super.getSourceConnectionAnchor(request);
            }
            Relation relation = (Relation)connectionEditPart.getModel();
            if (relation.getSource() == relation.getTarget()) {
                return new XYChopboxAnchor(this.getFigure());
            }
            EditPart editPart = reconnectRequest.getTarget();
            if (editPart == null || !editPart.getModel().equals(relation.getSource())) {
                return new XYChopboxAnchor(this.getFigure());
            }
            Point location = new Point(reconnectRequest.getLocation());
            this.getFigure().translateToRelative((Translatable)location);
            IFigure sourceFigure = ((TableViewEditPart)connectionEditPart.getSource()).getFigure();
            XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure());
            Rectangle bounds = sourceFigure.getBounds();
            Rectangle centerRectangle = new Rectangle(bounds.x + bounds.width / 4, bounds.y + bounds.height / 4, bounds.width / 2, bounds.height / 2);
            if (!centerRectangle.contains(location)) {
                Point point = TableViewEditPart.getIntersectionPoint(location, sourceFigure);
                anchor.setLocation(point);
            }
            return anchor;
        }
        if (request instanceof CreateConnectionRequest && (command = (connectionRequest = (CreateConnectionRequest)request).getStartCommand()) instanceof CreateCommentConnectionCommand) {
            return super.getTargetConnectionAnchor(request);
        }
        return new XYChopboxAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart editPart) {
        if (!(editPart instanceof RelationEditPart)) {
            return super.getTargetConnectionAnchor(editPart);
        }
        Relation relation = (Relation)editPart.getModel();
        XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure());
        Rectangle bounds = this.getFigure().getBounds();
        if (relation.getTargetXp() != -1 && relation.getTargetYp() != -1) {
            anchor.setLocation(new Point(bounds.x + bounds.width * relation.getTargetXp() / 100, bounds.y + bounds.height * relation.getTargetYp() / 100));
        }
        return anchor;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        CreateConnectionRequest connectionRequest;
        Command command;
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart connectionEditPart = reconnectRequest.getConnectionEditPart();
            if (!(connectionEditPart instanceof RelationEditPart)) {
                return super.getTargetConnectionAnchor(request);
            }
            Relation relation = (Relation)connectionEditPart.getModel();
            if (relation.getSource() == relation.getTarget()) {
                return new XYChopboxAnchor(this.getFigure());
            }
            EditPart editPart = reconnectRequest.getTarget();
            if (editPart == null || !editPart.getModel().equals(relation.getTarget())) {
                return new XYChopboxAnchor(this.getFigure());
            }
            Point location = new Point(reconnectRequest.getLocation());
            this.getFigure().translateToRelative((Translatable)location);
            IFigure targetFigure = ((TableViewEditPart)connectionEditPart.getTarget()).getFigure();
            XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure());
            Rectangle bounds = targetFigure.getBounds();
            Rectangle centerRectangle = new Rectangle(bounds.x + bounds.width / 4, bounds.y + bounds.height / 4, bounds.width / 2, bounds.height / 2);
            if (!centerRectangle.contains(location)) {
                Point point = TableViewEditPart.getIntersectionPoint(location, targetFigure);
                anchor.setLocation(point);
            }
            return anchor;
        }
        if (request instanceof CreateConnectionRequest && (command = (connectionRequest = (CreateConnectionRequest)request).getStartCommand()) instanceof CreateCommentConnectionCommand) {
            return super.getTargetConnectionAnchor(request);
        }
        return new XYChopboxAnchor(this.getFigure());
    }

    public static Point getIntersectionPoint(Point s, IFigure figure) {
        Rectangle r = figure.getBounds();
        int x1 = s.x - r.x;
        int x2 = r.x + r.width - s.x;
        int y1 = s.y - r.y;
        int y2 = r.y + r.height - s.y;
        int x = 0;
        int dx = 0;
        if (x1 < x2) {
            x = r.x;
            dx = x1;
        } else {
            x = r.x + r.width;
            dx = x2;
        }
        int y = 0;
        int dy = 0;
        if (y1 < y2) {
            y = r.y;
            dy = y1;
        } else {
            y = r.y + r.height;
            dy = y2;
        }
        if (dx < dy) {
            y = s.y;
        } else {
            x = s.x;
        }
        return new Point(x, y);
    }

    public IFigure getContentPane() {
        TableFigure figure = (TableFigure)super.getContentPane();
        return figure.getColumns();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TableViewComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TableViewGraphicalNodeEditPolicy());
    }
}

