/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.outline.dictionary;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.controller.editpart.outline.AbstractOutlineEditPart;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Dictionary;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Word;

public class DictionaryOutlineEditPart
extends AbstractOutlineEditPart {
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dictionary")) {
            this.refresh();
        }
    }

    protected List getModelChildren() {
        Dictionary dictionary = (Dictionary)this.getModel();
        List<Word> list = dictionary.getWordList();
        if (this.getDiagram().getDiagramContents().getSettings().getViewOrderBy() == 0) {
            Collections.sort(list, Word.LOGICAL_NAME_COMPARATOR);
        } else {
            Collections.sort(list, Word.PHYSICAL_NAME_COMPARATOR);
        }
        return list;
    }

    protected void refreshOutlineVisuals() {
        this.setWidgetText(String.valueOf(ResourceString.getResourceString("label.dictionary")) + " (" + this.getModelChildren().size() + ")");
        this.setWidgetImage(Activator.getImage("DICTIONARY"));
    }

    protected void refreshChildren() {
        super.refreshChildren();
        for (Object child : this.getChildren()) {
            EditPart part = (EditPart)child;
            part.refresh();
        }
    }
}

