/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.outline.sequence;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.editor.controller.command.diagram_contents.not_element.sequence.EditSequenceCommand;
import org.insightech.er.editor.controller.editpart.DeleteableEditPart;
import org.insightech.er.editor.controller.editpart.outline.AbstractOutlineEditPart;
import org.insightech.er.editor.controller.editpolicy.not_element.sequence.SequenceComponentEditPolicy;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;
import org.insightech.er.editor.view.dialog.outline.sequence.SequenceDialog;

public class SequenceOutlineEditPart
extends AbstractOutlineEditPart
implements DeleteableEditPart {
    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected void refreshOutlineVisuals() {
        Sequence sequence = (Sequence)this.getModel();
        if (!DBManagerFactory.getDBManager(this.getDiagram()).isSupported(5)) {
            ((TreeItem)this.getWidget()).setForeground(ColorConstants.lightGray);
        } else {
            ((TreeItem)this.getWidget()).setForeground(ColorConstants.black);
        }
        this.setWidgetText(this.getDiagram().filter(sequence.getName()));
        this.setWidgetImage(Activator.getImage("SEQUENCE"));
    }

    public void performRequest(Request request) {
        try {
            SequenceDialog dialog;
            Sequence sequence = (Sequence)this.getModel();
            ERDiagram diagram = this.getDiagram();
            if (request.getType().equals("open") && (dialog = new SequenceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), sequence, diagram)).open() == 0) {
                EditSequenceCommand command = new EditSequenceCommand(diagram, sequence, dialog.getResult());
                this.execute(command);
            }
            super.performRequest(request);
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new SequenceComponentEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public boolean isDeleteable() {
        return true;
    }
}

