/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.outline.table;

import java.beans.PropertyChangeEvent;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation.ChangeRelationPropertyCommand;
import org.insightech.er.editor.controller.editpart.outline.AbstractOutlineEditPart;
import org.insightech.er.editor.controller.editpolicy.element.connection.RelationEditPolicy;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.view.dialog.element.relation.RelationDialog;
import org.insightech.er.util.Format;

public class RelationOutlineEditPart
extends AbstractOutlineEditPart {
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("table_view_physicalName")) {
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("connection_attribute")) {
            this.refreshVisuals();
        }
    }

    protected void refreshOutlineVisuals() {
        Relation model = (Relation)this.getModel();
        ERDiagram diagram = (ERDiagram)this.getRoot().getContents().getModel();
        int viewMode = diagram.getDiagramContents().getSettings().getOutlineViewMode();
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (NormalColumn foreignKeyColumn : model.getForeignKeyColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (viewMode == 1) {
                sb.append(Format.null2blank(foreignKeyColumn.getPhysicalName()));
                continue;
            }
            if (viewMode == 0) {
                sb.append(Format.null2blank(foreignKeyColumn.getLogicalName()));
                continue;
            }
            sb.append(Format.null2blank(foreignKeyColumn.getLogicalName()));
            sb.append("/");
            sb.append(Format.null2blank(foreignKeyColumn.getPhysicalName()));
        }
        this.setWidgetText(sb.toString());
        this.setWidgetImage(Activator.getImage("FOREIGN_KEY"));
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new RelationEditPolicy());
    }

    public void performRequest(Request request) {
        Relation relation = (Relation)this.getModel();
        if (request.getType().equals("open")) {
            Relation copy = relation.copy();
            RelationDialog dialog = new RelationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), copy);
            if (dialog.open() == 0) {
                ChangeRelationPropertyCommand command = new ChangeRelationPropertyCommand(relation, copy);
                this.execute(command);
            }
        }
        super.performRequest(request);
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker((EditPart)this);
    }
}

