/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.outline.table;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.editor.controller.editpart.DeleteableEditPart;
import org.insightech.er.editor.controller.editpart.element.node.ERTableEditPart;
import org.insightech.er.editor.controller.editpart.outline.AbstractOutlineEditPart;
import org.insightech.er.editor.controller.editpolicy.element.node.NodeElementComponentEditPolicy;
import org.insightech.er.editor.model.AbstractModel;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.category.Category;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.view.dialog.element.table.TableDialog;

public class TableOutlineEditPart
extends AbstractOutlineEditPart
implements DeleteableEditPart {
    protected List getModelChildren() {
        ArrayList<AbstractModel> children = new ArrayList<AbstractModel>();
        ERTable table = (ERTable)this.getModel();
        Category category = this.getCurrentCategory();
        for (Relation relation : table.getIncomingRelations()) {
            if (category != null && !category.contains(relation.getSource())) continue;
            children.add(relation);
        }
        children.addAll(table.getIndexes());
        return children;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("table_view_physicalName")) {
            this.refreshName();
        } else if (evt.getPropertyName().equals("table_view_logicalName")) {
            this.refreshName();
        } else if (evt.getPropertyName().equals("columns")) {
            this.refresh();
        } else if (evt.getPropertyName().equals("indexes")) {
            this.refresh();
        }
    }

    protected void refreshName() {
        ERTable model = (ERTable)this.getModel();
        ERDiagram diagram = (ERDiagram)this.getRoot().getContents().getModel();
        String name = null;
        int viewMode = diagram.getDiagramContents().getSettings().getOutlineViewMode();
        if (viewMode == 1) {
            name = model.getPhysicalName() != null ? model.getPhysicalName() : "";
        } else if (viewMode == 0) {
            name = model.getLogicalName() != null ? model.getLogicalName() : "";
        } else {
            name = model.getLogicalName() != null ? model.getLogicalName() : "";
            name = String.valueOf(name) + "/";
            if (model.getPhysicalName() != null) {
                name = String.valueOf(name) + model.getPhysicalName();
            }
        }
        this.setWidgetText(diagram.filter(name));
        this.setWidgetImage(Activator.getImage("TABLE"));
    }

    protected void refreshOutlineVisuals() {
        this.refreshName();
        for (Object child : this.getChildren()) {
            EditPart part = (EditPart)child;
            part.refresh();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NodeElementComponentEditPolicy());
    }

    public void performRequest(Request request) {
        ERTable table = (ERTable)this.getModel();
        ERDiagram diagram = (ERDiagram)this.getRoot().getContents().getModel();
        if (request.getType().equals("open")) {
            ERTable copyTable = table.copyData();
            TableDialog dialog = new TableDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getViewer(), copyTable, diagram.getDiagramContents().getGroups());
            if (dialog.open() == 0) {
                CompoundCommand command = ERTableEditPart.createChangeTablePropertyCommand(diagram, table, copyTable);
                this.execute(command.unwrap());
            }
        }
        super.performRequest(request);
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public boolean isDeleteable() {
        return true;
    }
}

