/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.outline.tablespace;

import java.beans.PropertyChangeEvent;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.insightech.er.Activator;
import org.insightech.er.db.EclipseDBManagerFactory;
import org.insightech.er.editor.controller.command.diagram_contents.not_element.tablespace.EditTablespaceCommand;
import org.insightech.er.editor.controller.editpart.DeleteableEditPart;
import org.insightech.er.editor.controller.editpart.outline.AbstractOutlineEditPart;
import org.insightech.er.editor.controller.editpolicy.not_element.tablespace.TablespaceComponentEditPolicy;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.Tablespace;
import org.insightech.er.editor.view.dialog.outline.tablespace.TablespaceDialog;

public class TablespaceOutlineEditPart
extends AbstractOutlineEditPart
implements DeleteableEditPart {
    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected void refreshOutlineVisuals() {
        Tablespace tablespace = (Tablespace)this.getModel();
        this.setWidgetText(this.getDiagram().filter(tablespace.getName()));
        this.setWidgetImage(Activator.getImage("TABLESPACE"));
    }

    public void performRequest(Request request) {
        Tablespace tablespace = (Tablespace)this.getModel();
        ERDiagram diagram = this.getDiagram();
        if (request.getType().equals("open")) {
            TablespaceDialog dialog = EclipseDBManagerFactory.getEclipseDBManager(diagram).createTablespaceDialog();
            if (dialog == null) {
                Activator.showMessageDialog("dialog.message.tablespace.not.supported");
            } else {
                dialog.init(tablespace, diagram);
                if (dialog.open() == 0) {
                    EditTablespaceCommand command = new EditTablespaceCommand(diagram, tablespace, dialog.getResult());
                    this.execute(command);
                }
            }
        }
        super.performRequest(request);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TablespaceComponentEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public boolean isDeleteable() {
        return true;
    }
}

