/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpolicy.element.connection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.requests.BendpointRequest;
import org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation.bendpoint.MoveRelationBendpointCommand;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPart;
import org.insightech.er.editor.controller.editpart.element.connection.RelationEditPart;
import org.insightech.er.editor.controller.editpart.element.node.ERTableEditPart;
import org.insightech.er.editor.controller.editpolicy.element.connection.ERDiagramBendpointEditPolicy;
import org.insightech.er.editor.model.diagram_contents.element.connection.Bendpoint;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;

public class RelationBendpointEditPolicy
extends ERDiagramBendpointEditPolicy {
    protected void showMoveBendpointFeedback(BendpointRequest bendpointrequest) {
        Relation relation = (Relation)this.getHost().getModel();
        RelationEditPart editPart = (RelationEditPart)this.getHost();
        if (relation.getSource() == relation.getTarget()) {
            if (bendpointrequest.getIndex() != 1) {
                return;
            }
            Point point = bendpointrequest.getLocation();
            this.getConnection().translateToRelative((Translatable)point);
            Bendpoint rate = this.getRate(point);
            rate.setRelative(true);
            float rateX = (100.0f - (float)(rate.getX() / 2)) / 100.0f;
            float rateY = (100.0f - (float)(rate.getY() / 2)) / 100.0f;
            ERTableEditPart tableEditPart = (ERTableEditPart)editPart.getSource();
            Rectangle bounds = tableEditPart.getFigure().getBounds();
            Rectangle rect = new Rectangle();
            rect.x = (int)((float)bounds.x + (float)bounds.width * rateX);
            rect.y = (int)((float)bounds.y + (float)bounds.height * rateY);
            rect.width = bounds.width * rate.getX() / 100;
            rect.height = bounds.height * rate.getY() / 100;
            relation.setSourceLocationp(100, (int)(100.0f * rateY));
            relation.setTargetLocationp((int)(100.0f * rateX), 100);
            LayerManager manager = (LayerManager)tableEditPart.getRoot();
            IFigure layer = manager.getLayer((Object)"Primary Layer");
            this.getFeedbackLayer().setBounds(layer.getBounds());
            List children = this.getFeedbackLayer().getChildren();
            children.clear();
            this.getFeedbackLayer().repaint();
            ZoomManager zoomManager = ((ScalableFreeformRootEditPart)this.getHost().getRoot()).getZoomManager();
            double zoom = zoomManager.getZoom();
            Polyline feedbackFigure = new Polyline();
            feedbackFigure.addPoint(new Point((int)((double)rect.x * zoom), (int)((double)rect.y * zoom)));
            feedbackFigure.addPoint(new Point((int)((double)rect.x * zoom), (int)((double)(rect.y + rect.height) * zoom)));
            feedbackFigure.addPoint(new Point((int)((double)(rect.x + rect.width) * zoom), (int)((double)(rect.y + rect.height) * zoom)));
            feedbackFigure.addPoint(new Point((int)((double)(rect.x + rect.width) * zoom), (int)((double)rect.y * zoom)));
            feedbackFigure.addPoint(new Point((int)((double)rect.x * zoom), (int)((double)rect.y * zoom)));
            feedbackFigure.setLineStyle(2);
            feedbackFigure.translateToRelative((Translatable)feedbackFigure.getLocation());
            this.addFeedback((IFigure)feedbackFigure);
        } else {
            super.showMoveBendpointFeedback(bendpointrequest);
        }
    }

    protected void showCreateBendpointFeedback(BendpointRequest bendpointrequest) {
        Relation relation = (Relation)this.getHost().getModel();
        if (relation.getSource() == relation.getTarget()) {
            return;
        }
        super.showCreateBendpointFeedback(bendpointrequest);
    }

    protected void eraseConnectionFeedback(BendpointRequest request) {
        this.getFeedbackLayer().getChildren().clear();
        super.eraseConnectionFeedback(request);
    }

    protected Command getMoveBendpointCommand(BendpointRequest bendpointrequest) {
        Relation relation = (Relation)this.getHost().getModel();
        RelationEditPart editPart = (RelationEditPart)this.getHost();
        if (relation.getSource() == relation.getTarget()) {
            if (bendpointrequest.getIndex() != 1) {
                return null;
            }
            Point point = bendpointrequest.getLocation();
            Bendpoint rate = this.getRate(point);
            MoveRelationBendpointCommand command = new MoveRelationBendpointCommand(editPart, rate.getX(), rate.getY(), bendpointrequest.getIndex());
            return command;
        }
        Point point = bendpointrequest.getLocation();
        this.getConnection().translateToRelative((Translatable)point);
        MoveRelationBendpointCommand command = new MoveRelationBendpointCommand(editPart, point.x, point.y, bendpointrequest.getIndex());
        return command;
    }

    private Bendpoint getRate(Point point) {
        RelationEditPart editPart = (RelationEditPart)this.getHost();
        ERTableEditPart tableEditPart = (ERTableEditPart)editPart.getSource();
        Rectangle rectangle = tableEditPart.getFigure().getBounds();
        int xRate = (point.x - rectangle.x - rectangle.width) * 200 / rectangle.width;
        int yRate = (point.y - rectangle.y - rectangle.height) * 200 / rectangle.height;
        return new Bendpoint(xRate, yRate);
    }

    protected void showSelection() {
        super.showSelection();
        RelationEditPart editPart = (RelationEditPart)this.getHost();
        editPart.refresh();
    }

    protected void hideSelection() {
        super.hideSelection();
        RelationEditPart editPart = (RelationEditPart)this.getHost();
        editPart.refresh();
    }

    protected List createSelectionHandles() {
        Relation relation = (Relation)this.getHost().getModel();
        if (relation.getSource() == relation.getTarget()) {
            ArrayList<BendpointMoveHandle> list = new ArrayList<BendpointMoveHandle>();
            ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
            list.add(new BendpointMoveHandle(connEP, 1, 2));
            this.showSelectedLine();
            ERDiagramEditPart diagramEditPart = (ERDiagramEditPart)this.getHost().getRoot().getContents();
            diagramEditPart.refreshVisuals();
            return list;
        }
        return super.createSelectionHandles();
    }
}

