/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.excel.sheet_generator;

import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.ObjectModel;
import org.insightech.er.editor.model.dbexport.excel.ExportToExcelManager;
import org.insightech.er.editor.model.dbexport.excel.sheet_generator.SequenceSheetGenerator;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;
import org.insightech.er.util.POIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllSequencesSheetGenerator
extends SequenceSheetGenerator {
    @Override
    public void generate(IProgressMonitor monitor, HSSFWorkbook workbook, int sheetNo, boolean useLogicalNameAsSheetName, Map<String, Integer> sheetNameMap, Map<String, ObjectModel> sheetObjectMap, ERDiagram diagram, Map<String, ExportToExcelManager.LoopDefinition> loopDefinitionMap) {
        ExportToExcelManager.LoopDefinition loopDefinition = loopDefinitionMap.get(this.getTemplateSheetName());
        HSSFSheet newSheet = AllSequencesSheetGenerator.createNewSheet(workbook, sheetNo, loopDefinition.sheetName, sheetNameMap);
        sheetObjectMap.put(workbook.getSheetName(workbook.getSheetIndex((Sheet)newSheet)), diagram.getDiagramContents().getSequenceSet());
        HSSFSheet oldSheet = workbook.getSheetAt(sheetNo);
        boolean first = true;
        for (Sequence sequence : diagram.getDiagramContents().getSequenceSet()) {
            if (first) {
                first = false;
            } else {
                POIUtils.copyRow(oldSheet, newSheet, loopDefinition.startLine - 1, oldSheet.getLastRowNum(), newSheet.getLastRowNum() + loopDefinition.spaceLine + 1);
            }
            this.setSequenceData(workbook, newSheet, sequence);
            newSheet.setRowBreak(newSheet.getLastRowNum() + loopDefinition.spaceLine);
            monitor.worked(1);
        }
        if (first) {
            int i = loopDefinition.startLine - 1;
            while (i <= newSheet.getLastRowNum()) {
                HSSFRow row = newSheet.getRow(i);
                if (row != null) {
                    newSheet.removeRow((Row)row);
                }
                ++i;
            }
        }
    }

    @Override
    public String getTemplateSheetName() {
        return "all_sequences_template";
    }
}

