/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.excel.sheet_generator;

import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.ObjectModel;
import org.insightech.er.editor.model.dbexport.excel.ExportToExcelManager;
import org.insightech.er.editor.model.dbexport.excel.sheet_generator.AbstractSheetGenerator;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.ColumnSet;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.util.POIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnSheetGenerator
extends AbstractSheetGenerator {
    private static final String KEYWORD_SHEET_NAME = "$SHTN";
    private AbstractSheetGenerator.ColumnTemplate columnTemplate;

    private void clear() {
        this.columnTemplate = null;
    }

    public void setAllColumnsData(HSSFWorkbook workbook, HSSFSheet sheet, ERDiagram diagram) {
        this.clear();
        POIUtils.CellLocation cellLocation = POIUtils.findCell(sheet, FIND_KEYWORDS_OF_COLUMN);
        if (cellLocation != null) {
            int rowNum = cellLocation.r;
            HSSFRow templateRow = sheet.getRow(rowNum);
            if (this.columnTemplate == null) {
                this.columnTemplate = this.loadColumnTemplate(workbook, sheet, cellLocation);
            }
            int order = 1;
            for (ERTable table : diagram.getDiagramContents().getContents().getTableSet()) {
                if (diagram.getCurrentCategory() != null && !diagram.getCurrentCategory().contains(table)) continue;
                for (NormalColumn normalColumn : table.getExpandedColumns()) {
                    HSSFRow row = POIUtils.insertRow(sheet, rowNum++);
                    this.setColumnData(this.keywordsValueMap, this.columnTemplate, row, normalColumn, table, order);
                    ++order;
                }
            }
            this.setCellStyle(this.columnTemplate, sheet, cellLocation.r, rowNum - cellLocation.r, templateRow.getFirstCellNum());
        }
    }

    public String getSheetName() {
        String name = (String)this.keywordsValueMap.get(KEYWORD_SHEET_NAME);
        if (name == null) {
            name = "all attributes";
        }
        return name;
    }

    @Override
    public void generate(IProgressMonitor monitor, HSSFWorkbook workbook, int sheetNo, boolean useLogicalNameAsSheetName, Map<String, Integer> sheetNameMap, Map<String, ObjectModel> sheetObjectMap, ERDiagram diagram, Map<String, ExportToExcelManager.LoopDefinition> loopDefinitionMap) {
        String name = this.getSheetName();
        HSSFSheet newSheet = ColumnSheetGenerator.createNewSheet(workbook, sheetNo, name, sheetNameMap);
        sheetObjectMap.put(workbook.getSheetName(workbook.getSheetIndex((Sheet)newSheet)), new ColumnSet());
        this.setAllColumnsData(workbook, newSheet, diagram);
        monitor.worked(1);
    }

    @Override
    public String getTemplateSheetName() {
        return "column_template";
    }

    @Override
    public int getKeywordsColumnNo() {
        return 20;
    }

    @Override
    public String[] getKeywords() {
        return new String[]{"$LTN", "$PTN", "$TDSC", "$ORD", "$LCN", "$PCN", "$TYP", "$LEN", "$DEC", "$PK", "$NN", "$UK", "$FK", "$LRFTC", "$PRFTC", "$LRFT", "$PRFT", "$LRFC", "$PRFC", "$INC", "$DEF", "$CDSC", KEYWORD_SHEET_NAME};
    }

    @Override
    public int count(ERDiagram diagram) {
        return 1;
    }
}

