/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.excel.sheet_generator;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.ObjectModel;
import org.insightech.er.editor.model.StringObjectModel;
import org.insightech.er.editor.model.dbexport.excel.ExportToExcelManager;
import org.insightech.er.editor.model.dbexport.excel.sheet_generator.AbstractSheetGenerator;
import org.insightech.er.editor.model.tracking.ChangeTracking;
import org.insightech.er.util.POIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistorySheetGenerator
extends AbstractSheetGenerator {
    private static final String KEYWORD_DATE = "$DATE";
    private static final String KEYWORD_CONTENTS = "$CON";
    private static final String KEYWORD_DATE_FORMAT = "$FMT";
    private static final String KEYWORD_SHEET_NAME = "$SHTN";
    private static final String[] FIND_KEYWORDS_LIST = new String[]{"$DATE", "$CON"};

    @Override
    public void generate(IProgressMonitor monitor, HSSFWorkbook workbook, int sheetNo, boolean useLogicalNameAsSheetName, Map<String, Integer> sheetNameMap, Map<String, ObjectModel> sheetObjectMap, ERDiagram diagram, Map<String, ExportToExcelManager.LoopDefinition> loopDefinitionMap) {
        String sheetName = this.getSheetName();
        HSSFSheet newSheet = HistorySheetGenerator.createNewSheet(workbook, sheetNo, sheetName, sheetNameMap);
        sheetObjectMap.put(workbook.getSheetName(workbook.getSheetIndex((Sheet)newSheet)), new StringObjectModel(sheetName));
        this.setHistoryListData(workbook, newSheet, sheetObjectMap, diagram);
        monitor.worked(1);
    }

    public void setHistoryListData(HSSFWorkbook workbook, HSSFSheet sheet, Map<String, ObjectModel> sheetObjectMap, ERDiagram diagram) {
        POIUtils.CellLocation cellLocation = POIUtils.findCell(sheet, FIND_KEYWORDS_LIST);
        if (cellLocation != null) {
            int rowNum = cellLocation.r;
            HSSFRow templateRow = sheet.getRow(rowNum);
            AbstractSheetGenerator.ColumnTemplate columnTemplate = this.loadColumnTemplate(workbook, sheet, cellLocation);
            int order = 1;
            HSSFFont linkCellFont = null;
            int linkCol = -1;
            for (ChangeTracking changeTracking : diagram.getChangeTrackingList().getList()) {
                HSSFRow row = POIUtils.insertRow(sheet, rowNum++);
                for (int columnNum : columnTemplate.columnTemplateMap.keySet()) {
                    HSSFCell cell = row.createCell(columnNum);
                    String template = columnTemplate.columnTemplateMap.get(columnNum);
                    String value = null;
                    if ("$ORD".equals(template)) {
                        value = String.valueOf(order);
                    } else {
                        if (KEYWORD_DATE.equals(template)) {
                            SimpleDateFormat format = new SimpleDateFormat((String)this.keywordsValueMap.get(KEYWORD_DATE_FORMAT));
                            try {
                                value = format.format(changeTracking.getUpdatedDate());
                            }
                            catch (Exception exception) {
                                value = changeTracking.getUpdatedDate().toString();
                            }
                        } else if (KEYWORD_CONTENTS.equals(template)) {
                            value = changeTracking.getComment();
                        }
                        HSSFRichTextString text = new HSSFRichTextString(value);
                        cell.setCellValue((RichTextString)text);
                    }
                    ++order;
                }
            }
            this.setCellStyle(columnTemplate, sheet, cellLocation.r, rowNum - cellLocation.r, templateRow.getFirstCellNum());
            if (linkCol != -1) {
                int row = cellLocation.r;
                while (row < rowNum) {
                    HSSFCell cell = sheet.getRow(row).getCell(linkCol);
                    cell.getCellStyle().setFont(linkCellFont);
                    ++row;
                }
            }
        }
    }

    public String getSheetName() {
        String name = (String)this.keywordsValueMap.get(KEYWORD_SHEET_NAME);
        if (name == null) {
            name = "dialog.title.change.tracking";
        }
        return name;
    }

    @Override
    public String getTemplateSheetName() {
        return "history_template";
    }

    @Override
    public String[] getKeywords() {
        return new String[]{KEYWORD_DATE, KEYWORD_CONTENTS, "$ORD", KEYWORD_DATE_FORMAT, KEYWORD_SHEET_NAME};
    }

    @Override
    public int getKeywordsColumnNo() {
        return 28;
    }

    @Override
    public int count(ERDiagram diagram) {
        return 1;
    }
}

