/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.excel.sheet_generator;

import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.core.runtime.IProgressMonitor;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.ObjectModel;
import org.insightech.er.editor.model.dbexport.excel.ExportToExcelManager;
import org.insightech.er.editor.model.dbexport.excel.sheet_generator.AbstractSheetGenerator;
import org.insightech.er.util.POIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetIndexSheetGenerator
extends AbstractSheetGenerator {
    private static final String KEYWORD_SHEET_TYPE = "$SHTT";
    private static final String KEYWORD_NAME = "$NAM";
    private static final String KEYWORD_DESCRIPTION = "$DSC";
    private static final String KEYWORD_SHEET_NAME = "$SHTN";
    private static final String[] FIND_KEYWORDS_LIST = new String[]{"$SHTT", "$NAM", "$DSC"};

    @Override
    public void generate(IProgressMonitor monitor, HSSFWorkbook workbook, int sheetNo, boolean useLogicalNameAsSheetName, Map<String, Integer> sheetNameMap, Map<String, ObjectModel> sheetObjectMap, ERDiagram diagram, Map<String, ExportToExcelManager.LoopDefinition> loopDefinitionMap) {
        HSSFSheet sheet = workbook.getSheetAt(sheetNo);
        this.setSheetListData(workbook, sheet, sheetObjectMap, diagram);
        monitor.worked(1);
    }

    public void setSheetListData(HSSFWorkbook workbook, HSSFSheet sheet, Map<String, ObjectModel> sheetObjectMap, ERDiagram diagram) {
        POIUtils.CellLocation cellLocation = POIUtils.findCell(sheet, FIND_KEYWORDS_LIST);
        if (cellLocation != null) {
            int rowNum = cellLocation.r;
            HSSFRow templateRow = sheet.getRow(rowNum);
            AbstractSheetGenerator.ColumnTemplate columnTemplate = this.loadColumnTemplate(workbook, sheet, cellLocation);
            int order = 1;
            HSSFFont linkCellFont = null;
            int linkCol = -1;
            for (Map.Entry<String, ObjectModel> entry : sheetObjectMap.entrySet()) {
                String sheetName = entry.getKey();
                ObjectModel objectModel = entry.getValue();
                HSSFRow row = POIUtils.insertRow(sheet, rowNum++);
                for (int columnNum : columnTemplate.columnTemplateMap.keySet()) {
                    HSSFCell cell = row.createCell(columnNum);
                    String template = columnTemplate.columnTemplateMap.get(columnNum);
                    String value = null;
                    if ("$ORD".equals(template)) {
                        value = String.valueOf(order);
                    } else {
                        if (KEYWORD_SHEET_TYPE.equals(template)) {
                            value = ResourceString.getResourceString("label.object.type." + objectModel.getObjectType());
                        } else if (KEYWORD_NAME.equals(template)) {
                            value = sheetName;
                            HSSFHyperlink link = new HSSFHyperlink(2);
                            link.setAddress("'" + sheetName + "'!A1");
                            cell.setHyperlink((Hyperlink)link);
                            if (linkCellFont == null) {
                                linkCol = columnNum;
                                linkCellFont = POIUtils.copyFont(workbook, cell.getCellStyle().getFont((Workbook)workbook));
                                linkCellFont.setColor((short)12);
                                linkCellFont.setUnderline((byte)1);
                            }
                        } else if (KEYWORD_DESCRIPTION.equals(template)) {
                            value = objectModel.getDescription();
                        }
                        HSSFRichTextString text = new HSSFRichTextString(value);
                        cell.setCellValue((RichTextString)text);
                    }
                    ++order;
                }
            }
            this.setCellStyle(columnTemplate, sheet, cellLocation.r, rowNum - cellLocation.r, templateRow.getFirstCellNum());
            if (linkCol != -1) {
                int row = cellLocation.r;
                while (row < rowNum) {
                    HSSFCell cell = sheet.getRow(row).getCell(linkCol);
                    cell.getCellStyle().setFont(linkCellFont);
                    ++row;
                }
            }
        }
    }

    public String getSheetName() {
        String name = (String)this.keywordsValueMap.get(KEYWORD_SHEET_NAME);
        if (name == null) {
            name = "List of sheets";
        }
        return name;
    }

    @Override
    public String getTemplateSheetName() {
        return "sheet_index_template";
    }

    @Override
    public String[] getKeywords() {
        return new String[]{KEYWORD_SHEET_TYPE, KEYWORD_NAME, KEYWORD_DESCRIPTION, "$ORD", KEYWORD_SHEET_NAME};
    }

    @Override
    public int getKeywordsColumnNo() {
        return 24;
    }

    @Override
    public int count(ERDiagram diagram) {
        return 1;
    }
}

