/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.html.page_generator;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.html.ExportToHtmlManager;
import org.insightech.er.editor.model.dbexport.html.page_generator.HtmlReportPageGenerator;
import org.insightech.er.editor.model.diagram_contents.element.node.Location;
import org.insightech.er.editor.model.diagram_contents.element.node.table.TableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverviewHtmlReportPageGenerator {
    private Map<Object, Integer> idMap;

    public OverviewHtmlReportPageGenerator(Map<Object, Integer> idMap) {
        this.idMap = idMap;
    }

    public String getObjectId(Object object) {
        Integer id = this.idMap.get(object);
        if (id == null) {
            id = new Integer(this.idMap.size());
            this.idMap.put(object, id);
        }
        return String.valueOf(id);
    }

    public String generateFrame(List<HtmlReportPageGenerator> htmlReportPageGeneratorList) throws IOException {
        String template = ExportToHtmlManager.getTemplate("overview/overview-frame_template.html");
        Object[] args = new Object[]{this.generateFrameTable(htmlReportPageGeneratorList)};
        return MessageFormat.format(template, args);
    }

    private String generateFrameTable(List<HtmlReportPageGenerator> htmlReportPageGeneratorList) throws IOException {
        StringBuilder sb = new StringBuilder();
        String template = ExportToHtmlManager.getTemplate("overview/overview-frame_row_template.html");
        for (HtmlReportPageGenerator pageGenerator : htmlReportPageGeneratorList) {
            Object[] args = new Object[]{pageGenerator.getType(), pageGenerator.getPageTitle()};
            String row = MessageFormat.format(template, args);
            sb.append(row);
        }
        return sb.toString();
    }

    public String generateSummary(String imageSrc, Map<TableView, Location> tableLocationMap, List<HtmlReportPageGenerator> htmlReportPageGeneratorList) throws IOException {
        String template = ExportToHtmlManager.getTemplate("overview/overview-summary_template.html");
        Object[] args = new Object[]{this.generateImage(imageSrc, tableLocationMap), this.generateSummaryTable(htmlReportPageGeneratorList)};
        return MessageFormat.format(template, args);
    }

    private String generateImage(String imageSrc, Map<TableView, Location> tableLocationMap) throws IOException {
        if (imageSrc == null) {
            return "";
        }
        String template = ExportToHtmlManager.getTemplate("overview/overview-summary_image_template.html");
        Object[] args = new Object[]{imageSrc, this.generateImageMap(tableLocationMap)};
        return MessageFormat.format(template, args);
    }

    private String generateImageMap(Map<TableView, Location> tableLocationMap) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (tableLocationMap != null) {
            String template = ExportToHtmlManager.getTemplate("overview/overview-summary_image_map_template.html");
            for (Map.Entry<TableView, Location> entry : tableLocationMap.entrySet()) {
                Location location = entry.getValue();
                Object[] args = new Object[]{String.valueOf(location.x), String.valueOf(location.y), String.valueOf(location.x + location.width), String.valueOf(location.y + location.height), entry.getKey().getObjectType(), this.getObjectId(entry.getKey())};
                String row = MessageFormat.format(template, args);
                sb.append(row);
            }
        }
        return sb.toString();
    }

    private String generateSummaryTable(List<HtmlReportPageGenerator> htmlReportPageGeneratorList) throws IOException {
        StringBuilder sb = new StringBuilder();
        String template = ExportToHtmlManager.getTemplate("overview/overview-summary_row_template.html");
        for (HtmlReportPageGenerator pageGenerator : htmlReportPageGeneratorList) {
            Object[] args = new Object[]{pageGenerator.getType(), pageGenerator.getPageTitle()};
            String row = MessageFormat.format(template, args);
            sb.append(row);
        }
        return sb.toString();
    }

    public String generateAllClasses(ERDiagram diagram, List<HtmlReportPageGenerator> htmlReportPageGeneratorList) throws IOException {
        String template = ExportToHtmlManager.getTemplate("allclasses_template.html");
        Object[] args = new Object[]{this.generateAllClassesTable(diagram, htmlReportPageGeneratorList)};
        return MessageFormat.format(template, args);
    }

    private String generateAllClassesTable(ERDiagram diagram, List<HtmlReportPageGenerator> htmlReportPageGeneratorList) throws IOException {
        StringBuilder sb = new StringBuilder();
        String template = ExportToHtmlManager.getTemplate("allclasses_row_template.html");
        int i = 0;
        while (i < htmlReportPageGeneratorList.size()) {
            HtmlReportPageGenerator pageGenerator = htmlReportPageGeneratorList.get(i);
            for (Object object : pageGenerator.getObjectList(diagram)) {
                Object[] args = new Object[]{String.valueOf(pageGenerator.getType()) + "/" + pageGenerator.getObjectId(object) + ".html", pageGenerator.getObjectName(object)};
                String row = MessageFormat.format(template, args);
                sb.append(row);
            }
            ++i;
        }
        return sb.toString();
    }

    public int countAllClasses(ERDiagram diagram, List<HtmlReportPageGenerator> htmlReportPageGeneratorList) {
        int count = 0;
        int i = 0;
        while (i < htmlReportPageGeneratorList.size()) {
            HtmlReportPageGenerator pageGenerator = htmlReportPageGeneratorList.get(i);
            count += pageGenerator.getObjectList(diagram).size();
            ++i;
        }
        return count;
    }
}

