/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.html.page_generator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.html.page_generator.AbstractHtmlReportPageGenerator;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexHtmlReportPageGenerator
extends AbstractHtmlReportPageGenerator {
    public IndexHtmlReportPageGenerator(Map<Object, Integer> idMap) {
        super(idMap);
    }

    @Override
    public String getType() {
        return "index";
    }

    @Override
    public List<Object> getObjectList(ERDiagram diagram) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (NodeElement nodeElement : diagram.getDiagramContents().getContents()) {
            if (!(nodeElement instanceof ERTable)) continue;
            ERTable table = (ERTable)nodeElement;
            list.addAll(table.getIndexes());
        }
        return list;
    }

    @Override
    public String[] getContentArgs(ERDiagram diagram, Object object) throws IOException {
        Index index = (Index)object;
        ERTable table = index.getTable();
        String description = Format.null2blank(index.getDescription());
        String tableId = this.getObjectId(table);
        String tableName = Format.null2blank(table.getName());
        String unique = this.getUniqueString(index);
        List<NormalColumn> normalColumnList = index.getColumns();
        List<Boolean> descs = index.getDescs();
        String indexAttribute = this.generateIndexAttributeTable(table, normalColumnList, descs);
        return new String[]{description, tableId, tableName, this.getType(index), unique, indexAttribute};
    }

    private String getType(Index index) {
        if (index.isFullText()) {
            return "FULLTEXT";
        }
        return Format.null2blank(index.getType());
    }

    @Override
    public String getObjectName(Object object) {
        Index index = (Index)object;
        return index.getName();
    }

    @Override
    public String getObjectSummary(Object object) {
        Index index = (Index)object;
        return index.getDescription();
    }

    private String getUniqueString(Index index) {
        if (!index.isNonUnique()) {
            return "UNIQUE";
        }
        return "";
    }
}

