/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.html.page_generator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.html.page_generator.AbstractHtmlReportPageGenerator;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.view.View;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewHtmlReportPageGenerator
extends AbstractHtmlReportPageGenerator {
    public ViewHtmlReportPageGenerator(Map<Object, Integer> idMap) {
        super(idMap);
    }

    @Override
    public String getType() {
        return "view";
    }

    @Override
    public List<Object> getObjectList(ERDiagram diagram) {
        List<Object> list = diagram.getDiagramContents().getContents().getViewSet().getList();
        return list;
    }

    @Override
    public String[] getContentArgs(ERDiagram diagram, Object object) throws IOException {
        View view = (View)object;
        String description = Format.null2blank(view.getDescription());
        List<NormalColumn> normalColumnList = view.getExpandedColumns();
        String attributeTable = this.generateAttributeTable(diagram, normalColumnList);
        ArrayList<NormalColumn> foreignKeyList = new ArrayList<NormalColumn>();
        for (NormalColumn normalColumn : normalColumnList) {
            if (!normalColumn.isForeignKey()) continue;
            foreignKeyList.add(normalColumn);
        }
        String foreignKeyTable = this.generateForeignKeyTable(foreignKeyList);
        String attributeDetailTable = this.generateAttributeDetailTable(diagram, normalColumnList);
        return new String[]{Format.null2blank(description), Format.null2blank(view.getPhysicalName()), Format.null2blank(view.getSql()), attributeTable, foreignKeyTable, attributeDetailTable};
    }

    @Override
    public String getObjectName(Object object) {
        View view = (View)object;
        return view.getName();
    }

    @Override
    public String getObjectSummary(Object object) {
        View view = (View)object;
        return view.getDescription();
    }
}

