/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.diagram_contents.element.node;

import java.util.ArrayList;
import java.util.List;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.ObjectModel;
import org.insightech.er.editor.model.ViewableModel;
import org.insightech.er.editor.model.diagram_contents.element.connection.ConnectionElement;
import org.insightech.er.editor.model.diagram_contents.element.node.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeElement
extends ViewableModel
implements ObjectModel {
    private static final long serialVersionUID = -5143984125818569247L;
    public static final String PROPERTY_CHANGE_RECTANGLE = "rectangle";
    public static final String PROPERTY_CHANGE_INCOMING = "incoming";
    public static final String PROPERTY_CHANGE_OUTGOING = "outgoing";
    private Location location;
    private List<ConnectionElement> incomings = new ArrayList<ConnectionElement>();
    private List<ConnectionElement> outgoings = new ArrayList<ConnectionElement>();
    private ERDiagram diagram;

    public NodeElement() {
        this.location = new Location(0, 0, 0, 0);
    }

    public void setDiagram(ERDiagram diagram) {
        this.diagram = diagram;
    }

    public ERDiagram getDiagram() {
        return this.diagram;
    }

    public int getX() {
        return this.location.x;
    }

    public int getY() {
        return this.location.y;
    }

    public int getWidth() {
        return this.location.width;
    }

    public int getHeight() {
        return this.location.height;
    }

    public void setLocation(Location location) {
        this.location = location;
        this.firePropertyChange(PROPERTY_CHANGE_RECTANGLE, null, null);
    }

    public List<ConnectionElement> getIncomings() {
        return this.incomings;
    }

    public List<ConnectionElement> getOutgoings() {
        return this.outgoings;
    }

    public void setIncoming(List<ConnectionElement> relations) {
        this.incomings = relations;
        this.firePropertyChange(PROPERTY_CHANGE_INCOMING, null, null);
    }

    public void setOutgoing(List<ConnectionElement> relations) {
        this.outgoings = relations;
        this.firePropertyChange(PROPERTY_CHANGE_OUTGOING, null, null);
    }

    public void addIncoming(ConnectionElement relation) {
        this.incomings.add(relation);
        this.firePropertyChange(PROPERTY_CHANGE_INCOMING, null, null);
    }

    public void removeIncoming(ConnectionElement relation) {
        this.incomings.remove(relation);
        this.firePropertyChange(PROPERTY_CHANGE_INCOMING, null, null);
    }

    public void addOutgoing(ConnectionElement relation) {
        this.outgoings.add(relation);
        this.firePropertyChange(PROPERTY_CHANGE_OUTGOING, null, null);
    }

    public void removeOutgoing(ConnectionElement relation) {
        this.outgoings.remove(relation);
        this.firePropertyChange(PROPERTY_CHANGE_OUTGOING, null, null);
    }

    public List<NodeElement> getReferringElementList() {
        ArrayList<NodeElement> referringElementList = new ArrayList<NodeElement>();
        for (ConnectionElement connectionElement : this.getOutgoings()) {
            NodeElement targetElement = connectionElement.getTarget();
            referringElementList.add(targetElement);
        }
        return referringElementList;
    }

    public List<NodeElement> getReferedElementList() {
        ArrayList<NodeElement> referedElementList = new ArrayList<NodeElement>();
        for (ConnectionElement connectionElement : this.getIncomings()) {
            NodeElement sourceElement = connectionElement.getSource();
            referedElementList.add(sourceElement);
        }
        return referedElementList;
    }

    @Override
    public NodeElement clone() {
        NodeElement clone = (NodeElement)super.clone();
        clone.location = this.location.clone();
        clone.setIncoming(new ArrayList<ConnectionElement>());
        clone.setOutgoing(new ArrayList<ConnectionElement>());
        return clone;
    }
}

