/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.diagram_contents.element.node.note;

import java.util.List;
import org.insightech.er.editor.model.diagram_contents.element.connection.ConnectionElement;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Note
extends NodeElement
implements Comparable<Note> {
    private static final long serialVersionUID = -8810455349879962852L;
    public static final String PROPERTY_CHANGE_NOTE = "note";
    private String text;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.firePropertyChange(PROPERTY_CHANGE_NOTE, null, null);
    }

    @Override
    public List<NodeElement> getReferringElementList() {
        List<NodeElement> referringElementList = super.getReferringElementList();
        for (ConnectionElement connectionElement : this.getIncomings()) {
            NodeElement sourceElement = connectionElement.getSource();
            referringElementList.add(sourceElement);
        }
        return referringElementList;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public int compareTo(Note other) {
        int compareTo = 0;
        compareTo = Format.null2blank(this.text).compareTo(Format.null2blank(other.text));
        return compareTo;
    }

    @Override
    public String getName() {
        String name = this.text;
        if (name == null) {
            name = "";
        } else if (name.length() > 20) {
            name = name.substring(0, 20);
        }
        return name;
    }

    @Override
    public String getObjectType() {
        return PROPERTY_CHANGE_NOTE;
    }
}

