/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.diagram_contents.not_element.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.model.AbstractModel;
import org.insightech.er.editor.model.ObjectListModel;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceSet
extends AbstractModel
implements ObjectListModel,
Iterable<Sequence> {
    private static final long serialVersionUID = -120487815554383179L;
    public static final String PROPERTY_CHANGE_SEQUENCE_SET = "SequenceSet";
    private List<Sequence> sequenceList = new ArrayList<Sequence>();

    public void addSequence(Sequence sequence) {
        this.sequenceList.add(sequence);
        Collections.sort(this.sequenceList);
        this.firePropertyChange(PROPERTY_CHANGE_SEQUENCE_SET, null, null);
    }

    public int remove(Sequence sequence) {
        int index = this.sequenceList.indexOf(sequence);
        this.sequenceList.remove(index);
        this.firePropertyChange(PROPERTY_CHANGE_SEQUENCE_SET, null, null);
        return index;
    }

    public boolean contains(String name) {
        for (Sequence sequence : this.sequenceList) {
            if (!name.equalsIgnoreCase(sequence.getName())) continue;
            return true;
        }
        return false;
    }

    public Sequence get(String name) {
        for (Sequence sequence : this.sequenceList) {
            if (!name.equalsIgnoreCase(sequence.getName())) continue;
            return sequence;
        }
        return null;
    }

    public List<Sequence> getSequenceList() {
        return this.sequenceList;
    }

    @Override
    public Iterator<Sequence> iterator() {
        return this.sequenceList.iterator();
    }

    @Override
    public SequenceSet clone() {
        SequenceSet sequenceSet = (SequenceSet)super.clone();
        ArrayList<Sequence> newSequenceList = new ArrayList<Sequence>();
        for (Sequence sequence : this.sequenceList) {
            Sequence newSequence = (Sequence)sequence.clone();
            newSequenceList.add(newSequence);
        }
        sequenceSet.sequenceList = newSequenceList;
        return sequenceSet;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getName() {
        return ResourceString.getResourceString("label.object.type.sequence_list");
    }

    @Override
    public String getObjectType() {
        return "list";
    }
}

