/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.insightech.er.editor.model.diagram_contents.DiagramContents;
import org.insightech.er.editor.model.diagram_contents.element.connection.ConnectionElement;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeSet;
import org.insightech.er.editor.model.diagram_contents.element.node.category.Category;
import org.insightech.er.editor.model.diagram_contents.element.node.model_properties.ModelProperties;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.TableView;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.editor.model.diagram_contents.element.node.table.properties.TableViewProperties;
import org.insightech.er.editor.model.diagram_contents.element.node.table.unique_key.ComplexUniqueKey;
import org.insightech.er.editor.model.diagram_contents.element.node.view.View;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Dictionary;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Word;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.Tablespace;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.TablespaceSet;
import org.insightech.er.editor.model.settings.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyManager {
    private static NodeSet copyList = new NodeSet();
    private static int numberOfCopy;
    private Map<NodeElement, NodeElement> nodeElementMap;

    public static void copy(NodeSet nodeElementList) {
        CopyManager copyManager = new CopyManager();
        copyList = copyManager.copyNodeElementList(nodeElementList);
    }

    public static NodeSet paste() {
        ++numberOfCopy;
        CopyManager copyManager = new CopyManager();
        return copyManager.copyNodeElementList(copyList);
    }

    public static void clear() {
        copyList.clear();
        numberOfCopy = 0;
    }

    public static boolean canCopy() {
        return copyList != null && !copyList.isEmpty();
    }

    public static int getNumberOfCopy() {
        return numberOfCopy;
    }

    public Map<NodeElement, NodeElement> getNodeElementMap() {
        return this.nodeElementMap;
    }

    public NodeSet copyNodeElementList(NodeSet nodeElementList) {
        NodeSet copyList = new NodeSet();
        this.nodeElementMap = new HashMap<NodeElement, NodeElement>();
        HashMap<Column, Column> columnMap = new HashMap<Column, Column>();
        HashMap<ComplexUniqueKey, ComplexUniqueKey> complexUniqueKeyMap = new HashMap<ComplexUniqueKey, ComplexUniqueKey>();
        for (NodeElement nodeElement : nodeElementList) {
            if (nodeElement instanceof ModelProperties) continue;
            NodeElement cloneNodeElement = nodeElement.clone();
            copyList.addNodeElement(cloneNodeElement);
            this.nodeElementMap.put(nodeElement, cloneNodeElement);
            if (nodeElement instanceof ERTable) {
                CopyManager.copyColumnAndIndex((ERTable)nodeElement, (ERTable)cloneNodeElement, columnMap, complexUniqueKeyMap);
                continue;
            }
            if (!(nodeElement instanceof View)) continue;
            CopyManager.copyColumn((View)nodeElement, (View)cloneNodeElement, columnMap);
        }
        HashMap<ConnectionElement, ConnectionElement> connectionElementMap = new HashMap<ConnectionElement, ConnectionElement>();
        for (NodeElement nodeElement : this.nodeElementMap.keySet()) {
            NodeElement cloneNodeElement = this.nodeElementMap.get(nodeElement);
            CopyManager.replaceIncoming(nodeElement, cloneNodeElement, connectionElementMap, this.nodeElementMap);
        }
        for (NodeElement nodeElement : this.nodeElementMap.keySet()) {
            if (!(nodeElement instanceof ERTable)) continue;
            ERTable table = (ERTable)nodeElement;
            for (Column column : table.getColumns()) {
                NormalColumn oldColumn;
                if (!(column instanceof NormalColumn) || !(oldColumn = (NormalColumn)column).isForeignKey()) continue;
                NormalColumn newColumn = (NormalColumn)columnMap.get(oldColumn);
                newColumn.renewRelationList();
                for (Relation oldRelation : oldColumn.getRelationList()) {
                    Relation newRelation = (Relation)connectionElementMap.get(oldRelation);
                    if (newRelation != null) {
                        ComplexUniqueKey newReferencedComplexUniqueKey;
                        ComplexUniqueKey oldReferencedComplexUniqueKey;
                        NormalColumn oldReferencedColumn = newRelation.getReferencedColumn();
                        if (oldReferencedColumn != null) {
                            NormalColumn newReferencedColumn = (NormalColumn)columnMap.get(oldReferencedColumn);
                            newRelation.setReferencedColumn(newReferencedColumn);
                        }
                        if ((oldReferencedComplexUniqueKey = newRelation.getReferencedComplexUniqueKey()) != null && (newReferencedComplexUniqueKey = (ComplexUniqueKey)complexUniqueKeyMap.get(oldReferencedComplexUniqueKey)) != null) {
                            newRelation.setReferencedComplexUniqueKey(newReferencedComplexUniqueKey);
                        }
                        NormalColumn targetReferencedColumn = null;
                        for (NormalColumn referencedColumn : oldColumn.getReferencedColumnList()) {
                            if (referencedColumn.getColumnHolder() != oldRelation.getSourceTableView()) continue;
                            targetReferencedColumn = referencedColumn;
                            break;
                        }
                        NormalColumn newReferencedColumn = (NormalColumn)columnMap.get(targetReferencedColumn);
                        newColumn.removeReference(oldRelation);
                        newColumn.addReference(newReferencedColumn, newRelation);
                        continue;
                    }
                    newColumn.removeReference(oldRelation);
                }
            }
        }
        return copyList;
    }

    private static void replaceIncoming(NodeElement from, NodeElement to, Map<ConnectionElement, ConnectionElement> connectionElementMap, Map<NodeElement, NodeElement> nodeElementMap) {
        ArrayList<ConnectionElement> cloneIncomings = new ArrayList<ConnectionElement>();
        for (ConnectionElement incoming : from.getIncomings()) {
            NodeElement oldSource = incoming.getSource();
            NodeElement newSource = nodeElementMap.get(oldSource);
            if (newSource == null) continue;
            ConnectionElement cloneIncoming = incoming.clone();
            cloneIncoming.setSourceAndTarget(newSource, to);
            connectionElementMap.put(incoming, cloneIncoming);
            cloneIncomings.add(cloneIncoming);
            newSource.addOutgoing(cloneIncoming);
        }
        to.setIncoming(cloneIncomings);
    }

    private static void copyColumnAndIndex(ERTable from, ERTable to, Map<Column, Column> columnMap, Map<ComplexUniqueKey, ComplexUniqueKey> complexUniqueKeyMap) {
        CopyManager.copyColumn(from, to, columnMap);
        CopyManager.copyIndex(from, to, columnMap);
        CopyManager.copyComplexUniqueKey(from, to, columnMap, complexUniqueKeyMap);
    }

    private static void copyColumn(TableView from, TableView to, Map<Column, Column> columnMap) {
        ArrayList<Column> cloneColumns = new ArrayList<Column>();
        for (Column column : from.getColumns()) {
            Column cloneColumn = null;
            cloneColumn = column instanceof ColumnGroup ? column : (NormalColumn)column.clone();
            cloneColumns.add(cloneColumn);
            columnMap.put(column, cloneColumn);
        }
        to.setColumns(cloneColumns);
    }

    private static void copyComplexUniqueKey(ERTable from, ERTable to, Map<Column, Column> columnMap, Map<ComplexUniqueKey, ComplexUniqueKey> complexUniqueKeyMap) {
        ArrayList<ComplexUniqueKey> cloneComplexUniqueKeyList = new ArrayList<ComplexUniqueKey>();
        for (ComplexUniqueKey complexUniqueKey : from.getComplexUniqueKeyList()) {
            ComplexUniqueKey cloneComplexUniqueKey = (ComplexUniqueKey)complexUniqueKey.clone();
            complexUniqueKeyMap.put(complexUniqueKey, cloneComplexUniqueKey);
            ArrayList<NormalColumn> cloneColumns = new ArrayList<NormalColumn>();
            for (NormalColumn column : cloneComplexUniqueKey.getColumnList()) {
                cloneColumns.add((NormalColumn)columnMap.get(column));
            }
            cloneComplexUniqueKey.setColumnList(cloneColumns);
            cloneComplexUniqueKeyList.add(cloneComplexUniqueKey);
        }
        to.setComplexUniqueKeyList(cloneComplexUniqueKeyList);
    }

    private static void copyIndex(ERTable from, ERTable to, Map<Column, Column> columnMap) {
        ArrayList<Index> cloneIndexes = new ArrayList<Index>();
        for (Index index : from.getIndexes()) {
            Index cloneIndex = index.clone();
            ArrayList<NormalColumn> cloneIndexColumns = new ArrayList<NormalColumn>();
            for (NormalColumn indexColumn : cloneIndex.getColumns()) {
                cloneIndexColumns.add((NormalColumn)columnMap.get(indexColumn));
            }
            cloneIndex.setColumns(cloneIndexColumns);
            cloneIndexes.add(cloneIndex);
        }
        to.setIndexes(cloneIndexes);
    }

    public DiagramContents copy(DiagramContents originalDiagramContents) {
        DiagramContents copyDiagramContents = new DiagramContents();
        copyDiagramContents.setContents(this.copyNodeElementList(originalDiagramContents.getContents()));
        Map<NodeElement, NodeElement> nodeElementMap = this.getNodeElementMap();
        Settings settings = (Settings)originalDiagramContents.getSettings().clone();
        this.setSettings(nodeElementMap, settings);
        copyDiagramContents.setSettings(settings);
        this.setColumnGroup(copyDiagramContents, originalDiagramContents);
        copyDiagramContents.setSequenceSet(originalDiagramContents.getSequenceSet().clone());
        copyDiagramContents.setTriggerSet(originalDiagramContents.getTriggerSet().clone());
        this.setWord(copyDiagramContents, originalDiagramContents);
        this.setTablespace(copyDiagramContents, originalDiagramContents);
        return copyDiagramContents;
    }

    private void setSettings(Map<NodeElement, NodeElement> nodeElementMap, Settings settings) {
        for (Category category : settings.getCategorySetting().getAllCategories()) {
            ArrayList<NodeElement> newContents = new ArrayList<NodeElement>();
            for (NodeElement nodeElement : category.getContents()) {
                newContents.add(nodeElementMap.get(nodeElement));
            }
            category.setContents(newContents);
        }
    }

    private void setColumnGroup(DiagramContents copyDiagramContents, DiagramContents originalDiagramContents) {
        HashMap<ColumnGroup, ColumnGroup> columnGroupMap = new HashMap<ColumnGroup, ColumnGroup>();
        for (ColumnGroup columnGroup : originalDiagramContents.getGroups()) {
            ColumnGroup newColumnGroup = columnGroup.clone();
            copyDiagramContents.getGroups().add(newColumnGroup);
            columnGroupMap.put(columnGroup, newColumnGroup);
        }
        for (TableView tableView : copyDiagramContents.getContents().getTableViewList()) {
            ArrayList<Column> newColumns = new ArrayList<Column>();
            for (Column column : tableView.getColumns()) {
                if (column instanceof ColumnGroup) {
                    newColumns.add((Column)columnGroupMap.get((ColumnGroup)column));
                    continue;
                }
                newColumns.add(column);
            }
            tableView.setColumns(newColumns);
        }
    }

    private void setWord(DiagramContents copyDiagramContents, DiagramContents originalDiagramContents) {
        Word newWord;
        Word oldWord;
        HashMap<Word, Word> wordMap = new HashMap<Word, Word>();
        Dictionary copyDictionary = copyDiagramContents.getDictionary();
        for (Word word : originalDiagramContents.getDictionary().getWordList()) {
            Word newWord2 = (Word)word.clone();
            wordMap.put(word, newWord2);
        }
        for (TableView tableView : copyDiagramContents.getContents().getTableViewList()) {
            for (NormalColumn normalColumn : tableView.getNormalColumns()) {
                oldWord = normalColumn.getWord();
                if (oldWord == null) continue;
                newWord = (Word)wordMap.get(oldWord);
                normalColumn.setWord(newWord);
                copyDictionary.add(normalColumn);
            }
        }
        for (ColumnGroup columnGroup : copyDiagramContents.getGroups()) {
            for (NormalColumn normalColumn : columnGroup.getColumns()) {
                oldWord = normalColumn.getWord();
                if (oldWord == null) continue;
                newWord = (Word)wordMap.get(oldWord);
                normalColumn.setWord(newWord);
                copyDictionary.add(normalColumn);
            }
        }
    }

    private void setTablespace(DiagramContents copyDiagramContents, DiagramContents originalDiagramContents) {
        HashMap<Tablespace, Tablespace> tablespaceMap = new HashMap<Tablespace, Tablespace>();
        TablespaceSet copyTablespaceSet = copyDiagramContents.getTablespaceSet();
        for (Tablespace tablespace : originalDiagramContents.getTablespaceSet()) {
            Tablespace newTablespace = tablespace.clone();
            tablespaceMap.put(tablespace, newTablespace);
            copyTablespaceSet.addTablespace(newTablespace);
        }
        for (TableView tableView : copyDiagramContents.getContents().getTableViewList()) {
            TableViewProperties tableProperties = tableView.getTableViewProperties();
            Tablespace oldTablespace = tableProperties.getTableSpace();
            Tablespace newTablespace = (Tablespace)tablespaceMap.get(oldTablespace);
            tableProperties.setTableSpace(newTablespace);
        }
        TableViewProperties defaultTableProperties = copyDiagramContents.getSettings().getTableViewProperties();
        Tablespace oldDefaultTablespace = defaultTableProperties.getTableSpace();
        Tablespace newDefaultTablespace = (Tablespace)tablespaceMap.get(oldDefaultTablespace);
        defaultTableProperties.setTableSpace(newDefaultTablespace);
    }
}

