/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.search;

import java.util.ArrayList;
import java.util.List;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.note.Note;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.TypeData;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Word;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.model.search.ReplaceResult;
import org.insightech.er.util.Check;
import org.insightech.er.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceManager {
    private static final int[] ALPHABET_TYPES = new int[]{1, 2, 11, 28, 13, 21};
    private static final int[] DEGIT_TYPES = new int[]{31, 32, 16, 17, 24, 25};
    private static final int[] REQUIRED_TYPES = new int[]{2, 12, 29, 14, 20, 22};
    private static final int[] EXCLUDE_TYPES = new int[]{3, 30, 15, 23};
    private static final List<String> replaceWordList = new ArrayList<String>();

    public static ReplaceResult replace(int type, Object object, String keyword, String replaceWord, String database) {
        TypeData oldTypeData;
        ReplaceManager.addReplaceWord(replaceWord);
        int[] nArray = EXCLUDE_TYPES;
        int n = EXCLUDE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int excludeType = nArray[n2];
            if (type == excludeType) {
                return null;
            }
            ++n2;
        }
        ReplaceManager.checkAlphabet(type, replaceWord);
        ReplaceManager.checkDegit(type, replaceWord);
        if (type == 1) {
            Relation relation = (Relation)object;
            String original = relation.getName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            relation.setName(str);
            return new ReplaceResult(original);
        }
        if (type == 2) {
            Index index = (Index)object;
            String original = index.getName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            index.setName(str);
            return new ReplaceResult(original);
        }
        if (type == 3) {
            return null;
        }
        if (type == 4) {
            Note note = (Note)object;
            String original = note.getText();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            note.setText(str);
            return new ReplaceResult(original);
        }
        if (type == 5) {
            NameValue property = (NameValue)object;
            String original = property.getName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            property.setName(str);
            return new ReplaceResult(original);
        }
        if (type == 6) {
            NameValue property = (NameValue)object;
            String original = property.getValue();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            property.setValue(str);
            return new ReplaceResult(original);
        }
        if (type == 11) {
            ERTable table = (ERTable)object;
            String original = table.getPhysicalName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            table.setPhysicalName(str);
            return new ReplaceResult(original);
        }
        if (type == 12) {
            ERTable table = (ERTable)object;
            String original = table.getLogicalName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            table.setLogicalName(str);
            return new ReplaceResult(original);
        }
        if (type == 13 || type == 21) {
            NormalColumn column = (NormalColumn)object;
            String original = column.getForeignKeyPhysicalName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            column.setForeignKeyPhysicalName(str);
            return new ReplaceResult(original);
        }
        if (type == 14 || type == 22) {
            NormalColumn column = (NormalColumn)object;
            String original = column.getForeignKeyLogicalName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            ReplaceManager.checkRequired(type, str);
            column.setForeignKeyLogicalName(str);
            return new ReplaceResult(original);
        }
        if (type == 18 || type == 26) {
            NormalColumn column = (NormalColumn)object;
            String original = column.getDefaultValue();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            column.setDefaultValue(str);
            return new ReplaceResult(original);
        }
        if (type == 19) {
            NormalColumn column = (NormalColumn)object;
            String original = column.getForeignKeyDescription();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            column.setForeignKeyDescription(str);
            return new ReplaceResult(original);
        }
        if (type == 20 || type == 27) {
            ColumnGroup group = (ColumnGroup)object;
            String original = group.getGroupName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            group.setGroupName(str);
            return new ReplaceResult(original);
        }
        if (type == 28) {
            Word word = (Word)object;
            String original = word.getPhysicalName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            word.setPhysicalName(str);
            return new ReplaceResult(original);
        }
        if (type == 29) {
            Word word = (Word)object;
            String original = word.getLogicalName();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            ReplaceManager.checkRequired(type, str);
            word.setLogicalName(str);
            return new ReplaceResult(original);
        }
        if (type == 31) {
            Word word = (Word)object;
            String original = String.valueOf(word.getTypeData().getLength());
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            if (!str.equals("")) {
                oldTypeData = word.getTypeData();
                TypeData newTypeData = new TypeData(Integer.parseInt(str), oldTypeData.getDecimal(), oldTypeData.isArray(), oldTypeData.getArrayDimension(), oldTypeData.isUnsigned(), oldTypeData.getArgs());
                word.setType(word.getType(), newTypeData, database);
            }
            return new ReplaceResult(original);
        }
        if (type == 32) {
            Word word = (Word)object;
            String original = String.valueOf(word.getTypeData().getDecimal());
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            if (!str.equals("")) {
                oldTypeData = word.getTypeData();
                TypeData newTypeData = new TypeData(oldTypeData.getLength(), Integer.parseInt(str), oldTypeData.isArray(), oldTypeData.getArrayDimension(), oldTypeData.isUnsigned(), oldTypeData.getArgs());
                word.setType(word.getType(), newTypeData, database);
            }
            return new ReplaceResult(original);
        }
        if (type == 33) {
            Word word = (Word)object;
            String original = word.getDescription();
            String str = ReplaceManager.replace(original, keyword, replaceWord);
            if (!ReplaceManager.checkRequired(type, str)) {
                return null;
            }
            word.setDescription(str);
            return new ReplaceResult(original);
        }
        return null;
    }

    private static boolean checkAlphabet(int type, String str) {
        if (str == null || str.equals("")) {
            return true;
        }
        int[] nArray = ALPHABET_TYPES;
        int n = ALPHABET_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int alphabetType = nArray[n2];
            if (type == alphabetType && !Check.isAlphabet(str)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean checkDegit(int type, String str) {
        if (str == null || str.equals("")) {
            return true;
        }
        int[] nArray = DEGIT_TYPES;
        int n = DEGIT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int degitType = nArray[n2];
            if (type == degitType) {
                try {
                    int len = Integer.parseInt(str);
                    if (len < 0) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private static boolean checkRequired(int type, String str) {
        int[] nArray = REQUIRED_TYPES;
        int n = REQUIRED_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int requiredType = nArray[n2];
            if (type == requiredType && (str == null || str.trim().equals(""))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String replace(String str, String keyword, String replaceWord) {
        return str.replaceAll(keyword, replaceWord);
    }

    private static void addReplaceWord(String replaceWord) {
        if (!replaceWordList.contains(replaceWord)) {
            replaceWordList.add(0, replaceWord);
        }
        if (replaceWordList.size() > 20) {
            replaceWordList.remove(replaceWordList.size() - 1);
        }
    }

    public static List<String> getReplaceWordList() {
        return replaceWordList;
    }

    public static void undo(int type, Object object, String str) {
        if (type == 1) {
            Relation relation = (Relation)object;
            relation.setName(str);
        } else if (type == 2) {
            Index index = (Index)object;
            index.setName(str);
        } else if (type != 3) {
            if (type == 4) {
                Note note = (Note)object;
                note.setText(str);
            } else if (type == 5) {
                NameValue property = (NameValue)object;
                property.setName(str);
            } else if (type == 6) {
                NameValue property = (NameValue)object;
                property.setValue(str);
            } else if (type == 11) {
                ERTable table = (ERTable)object;
                table.setPhysicalName(str);
            } else if (type == 12) {
                ERTable table = (ERTable)object;
                table.setLogicalName(str);
            } else if (type == 13 || type == 21) {
                NormalColumn column = (NormalColumn)object;
                column.setForeignKeyPhysicalName(str);
            } else if (type == 14 || type == 22) {
                NormalColumn column = (NormalColumn)object;
                column.setForeignKeyLogicalName(str);
            } else if (type == 18 || type == 26) {
                NormalColumn column = (NormalColumn)object;
                column.setDefaultValue(str);
            } else if (type == 19) {
                NormalColumn column = (NormalColumn)object;
                column.setForeignKeyDescription(str);
            } else if (type == 20 || type == 27) {
                ColumnGroup group = (ColumnGroup)object;
                group.setGroupName(str);
            }
        }
    }
}

