/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.insightech.er.ResourceString;
import org.insightech.er.preference.PreferenceInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationSetting
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7691417386790834828L;
    private List<String> selectedTranslations = new ArrayList<String>();
    private boolean use;

    public List<String> getAllTranslations() {
        List<String> list = PreferenceInitializer.getAllUserTranslations();
        list.add(ResourceString.getResourceString("label.translation.default"));
        return list;
    }

    public List<String> getSelectedTranslations() {
        return this.selectedTranslations;
    }

    public void setSelectedTranslations(List<String> selectedTranslations) {
        this.selectedTranslations = selectedTranslations;
    }

    public void selectDefault() {
        this.selectedTranslations.add(ResourceString.getResourceString("label.translation.default"));
    }

    public boolean isUse() {
        return this.use;
    }

    public void setUse(boolean use) {
        this.use = use;
    }

    public boolean isSelected(String translationName) {
        for (String translation : this.selectedTranslations) {
            if (!translation.equals(translationName)) continue;
            return true;
        }
        return false;
    }

    public void addTranslationAsSelected(String translation) {
        this.selectedTranslations.add(translation);
    }

    public Object clone() {
        try {
            TranslationSetting settings = (TranslationSetting)super.clone();
            settings.selectedTranslations = new ArrayList<String>();
            for (String selectedTranslation : this.selectedTranslations) {
                settings.selectedTranslations.add(selectedTranslation);
            }
            return settings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void load() {
    }

    protected void parseString(String stringList) {
    }
}

