/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.tracking;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatedNodeElement
implements Serializable {
    private static final long serialVersionUID = -1547406607441505291L;
    private NodeElement nodeElement;
    private Set<Column> addedColumns;
    private Set<Column> updatedColumns;
    private Set<Column> removedColumns;

    public UpdatedNodeElement(NodeElement nodeElement) {
        this.nodeElement = nodeElement;
        this.addedColumns = new HashSet<Column>();
        this.updatedColumns = new HashSet<Column>();
        this.removedColumns = new HashSet<Column>();
    }

    public NodeElement getNodeElement() {
        return this.nodeElement;
    }

    public void setAddedColumns(Collection<NormalColumn> columns) {
        this.addedColumns.clear();
        this.addedColumns.addAll(columns);
    }

    public void setUpdatedColumns(Collection<NormalColumn> columns) {
        this.updatedColumns.clear();
        this.updatedColumns.addAll(columns);
    }

    public void setRemovedColumns(Collection<NormalColumn> columns) {
        this.removedColumns.clear();
        this.removedColumns.addAll(columns);
    }

    public boolean isAdded(Column column) {
        return this.addedColumns.contains(column);
    }

    public boolean isUpdated(Column column) {
        return this.updatedColumns.contains(column);
    }

    public Set<Column> getRemovedColumns() {
        return this.removedColumns;
    }
}

