/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IFileEditorInput;
import org.insightech.er.Activator;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.controller.command.common.ChangeSettingsCommand;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.settings.Settings;

public abstract class AbstractBaseAction
extends Action {
    private ERDiagramEditor editor;

    public AbstractBaseAction(String id, String text, ERDiagramEditor editor) {
        this(id, text, 0, editor);
    }

    public AbstractBaseAction(String id, String text, int style, ERDiagramEditor editor) {
        super(text, style);
        this.setId(id);
        this.editor = editor;
    }

    protected void refreshProject() {
        IFile iFile = ((IFileEditorInput)this.getEditorPart().getEditorInput()).getFile();
        IProject project = iFile.getProject();
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            Activator.showExceptionDialog(e);
        }
    }

    protected ERDiagram getDiagram() {
        EditPart editPart = this.editor.getGraphicalViewer().getContents();
        ERDiagram diagram = (ERDiagram)editPart.getModel();
        return diagram;
    }

    protected GraphicalViewer getGraphicalViewer() {
        return this.editor.getGraphicalViewer();
    }

    public final void runWithEvent(Event event) {
        try {
            try {
                this.execute(event);
            }
            catch (Exception e) {
                Activator.showExceptionDialog(e);
                Settings newSettings = this.getChangedSettings();
                if (newSettings != null && !this.getDiagram().getDiagramContents().getSettings().equals(newSettings)) {
                    ChangeSettingsCommand command = new ChangeSettingsCommand(this.getDiagram(), newSettings);
                    this.execute(command);
                }
            }
        }
        finally {
            Settings newSettings = this.getChangedSettings();
            if (newSettings != null && !this.getDiagram().getDiagramContents().getSettings().equals(newSettings)) {
                ChangeSettingsCommand command = new ChangeSettingsCommand(this.getDiagram(), newSettings);
                this.execute(command);
            }
        }
    }

    public abstract void execute(Event var1) throws Exception;

    protected void execute(Command command) {
        this.editor.getGraphicalViewer().getEditDomain().getCommandStack().execute(command);
    }

    protected Settings getChangedSettings() {
        return null;
    }

    protected ERDiagramEditor getEditorPart() {
        return this.editor;
    }
}

