/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action.dbexport;

import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RetargetAction;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.ddl.validator.ValidateResult;
import org.insightech.er.editor.model.dbexport.ddl.validator.Validator;
import org.insightech.er.editor.model.settings.DBSetting;
import org.insightech.er.editor.view.action.AbstractBaseAction;
import org.insightech.er.editor.view.dialog.dbexport.ExportDBSettingDialog;
import org.insightech.er.editor.view.dialog.dbexport.ExportErrorDialog;
import org.insightech.er.editor.view.dialog.dbexport.ExportToDBDialog;

public class ExportToDBAction
extends AbstractBaseAction {
    public static final String ID = ExportToDBAction.class.getName();
    private Validator validator = new Validator();

    public ExportToDBAction(ERDiagramEditor editor) {
        super(ID, ResourceString.getResourceString("action.title.export.db"), editor);
    }

    public void execute(Event event) {
        ERDiagram diagram = this.getDiagram();
        List<ValidateResult> errorList = this.validator.validate(diagram);
        if (!errorList.isEmpty()) {
            ExportErrorDialog dialog = new ExportErrorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), errorList);
            dialog.open();
            return;
        }
        ExportDBSettingDialog dialog = new ExportDBSettingDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), diagram);
        if (dialog.open() == 0) {
            String ddl = dialog.getDdl();
            DBSetting dbSetting = dialog.getDbSetting();
            ExportToDBDialog exportToDBDialog = new ExportToDBDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), diagram, dbSetting, ddl);
            exportToDBDialog.open();
        }
    }

    public static class ExportToDBRetargetAction
    extends RetargetAction {
        public ExportToDBRetargetAction() {
            super(ID, ResourceString.getResourceString("action.title.export.db"));
            this.setImageDescriptor(Activator.getImageDescriptor("EXPORT_TO_DB"));
            this.setToolTipText(this.getText());
        }
    }
}

