/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action.edit;

import java.util.ArrayList;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPart;
import org.insightech.er.editor.controller.editpart.element.node.ModelPropertiesEditPart;
import org.insightech.er.editor.controller.editpart.element.node.NodeElementEditPart;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeSet;
import org.insightech.er.editor.model.edit.CopyManager;

public class CopyAction
extends SelectionAction {
    public CopyAction(IWorkbenchPart part) {
        super(part);
        this.setText(ResourceString.getResourceString("action.title.copy"));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setId(ActionFactory.COPY.getId());
    }

    protected boolean calculateEnabled() {
        ArrayList list = new ArrayList(this.getSelectedObjects());
        if (list.isEmpty()) {
            return false;
        }
        return (list.size() != 1 || !(list.get(0) instanceof ModelPropertiesEditPart)) && !(list.get(0) instanceof ERDiagramEditPart);
    }

    public void run() {
        this.copy();
    }

    private void copy() {
        if (!this.calculateEnabled()) {
            return;
        }
        CopyManager.clear();
        NodeSet nodeElementList = new NodeSet();
        for (Object object : this.getSelectedObjects()) {
            if (!(object instanceof NodeElementEditPart)) continue;
            NodeElementEditPart editPart = (NodeElementEditPart)object;
            NodeElement nodeElement = (NodeElement)editPart.getModel();
            nodeElementList.addNodeElement(nodeElement);
        }
        CopyManager.copy(nodeElementList);
    }
}

