/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action.line;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.controller.command.diagram_contents.element.node.MoveElementCommand;
import org.insightech.er.editor.controller.editpart.element.AbstractModelEditPart;
import org.insightech.er.editor.controller.editpart.element.node.ERTableEditPart;
import org.insightech.er.editor.controller.editpart.element.node.NodeElementEditPart;
import org.insightech.er.editor.controller.editpart.element.node.NoteEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.view.action.AbstractBaseSelectionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalLineAction
extends AbstractBaseSelectionAction {
    public static final String ID = HorizontalLineAction.class.getName();
    private static final Comparator<AbstractModelEditPart> comparator = new AbstractModelEditPartHorizontalComparator();

    public HorizontalLineAction(ERDiagramEditor editor) {
        super(ID, ResourceString.getResourceString("action.title.horizontal.line"), editor);
        this.setImageDescriptor(Activator.getImageDescriptor("HORIZONTAL_LINE"));
        this.setToolTipText(ResourceString.getResourceString("action.title.horizontal.line"));
    }

    @Override
    protected boolean calculateEnabled() {
        Command cmd = this.createCommand();
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    @Override
    protected void execute(Event event) {
        this.execute(this.createCommand());
    }

    private Command createCommand() {
        Command command = null;
        ArrayList<NodeElementEditPart> list = new ArrayList<NodeElementEditPart>();
        for (Object object : this.getSelectedObjects()) {
            if (!(object instanceof ERTableEditPart) && !(object instanceof NoteEditPart)) continue;
            list.add((NodeElementEditPart)object);
        }
        if (list.size() < 3) {
            return null;
        }
        NodeElementEditPart firstEditPart = this.getFirstEditPart(list);
        list.remove(firstEditPart);
        Collections.sort(list, comparator);
        Rectangle firstRectangle = firstEditPart.getFigure().getBounds();
        int start = firstRectangle.x;
        int left = firstRectangle.x + firstRectangle.width;
        Rectangle lastRectangle = ((NodeElementEditPart)list.remove(list.size() - 1)).getFigure().getBounds();
        int right = lastRectangle.x;
        command = left > right ? this.alignToStart(start, list) : this.adjustSpace(start, left, right, list);
        return command;
    }

    private Command alignToStart(int start, List<NodeElementEditPart> list) {
        CompoundCommand command = new CompoundCommand();
        ERDiagram diagram = this.getDiagram();
        for (AbstractModelEditPart abstractModelEditPart : list) {
            NodeElement nodeElement = (NodeElement)abstractModelEditPart.getModel();
            MoveElementCommand moveCommand = new MoveElementCommand(diagram, abstractModelEditPart.getFigure().getBounds(), start, nodeElement.getY(), nodeElement.getWidth(), nodeElement.getHeight(), nodeElement);
            command.add((Command)moveCommand);
        }
        return command.unwrap();
    }

    private Command adjustSpace(int start, int left, int right, List<NodeElementEditPart> list) {
        CompoundCommand command = new CompoundCommand();
        ERDiagram diagram = this.getDiagram();
        int totalWidth = 0;
        for (AbstractModelEditPart abstractModelEditPart : list) {
            totalWidth += abstractModelEditPart.getFigure().getBounds().width;
        }
        int n = (right - left - totalWidth) / (list.size() + 1);
        int x = left;
        for (AbstractModelEditPart abstractModelEditPart : list) {
            NodeElement nodeElement = (NodeElement)abstractModelEditPart.getModel();
            int nextX = (x += n) + abstractModelEditPart.getFigure().getBounds().width;
            if (x < start) {
                x = start;
            }
            MoveElementCommand moveCommand = new MoveElementCommand(diagram, abstractModelEditPart.getFigure().getBounds(), x, nodeElement.getY(), nodeElement.getWidth(), nodeElement.getHeight(), nodeElement);
            command.add((Command)moveCommand);
            x = nextX;
        }
        return command.unwrap();
    }

    private NodeElementEditPart getFirstEditPart(List<NodeElementEditPart> list) {
        NodeElementEditPart firstEditPart = null;
        for (NodeElementEditPart editPart : list) {
            if (firstEditPart == null) {
                firstEditPart = editPart;
                continue;
            }
            if (firstEditPart.getFigure().getBounds().x <= editPart.getFigure().getBounds().x) continue;
            firstEditPart = editPart;
        }
        return firstEditPart;
    }

    @Override
    protected List<Command> getCommand(EditPart editPart, Event event) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbstractModelEditPartHorizontalComparator
    implements Comparator<AbstractModelEditPart> {
        private AbstractModelEditPartHorizontalComparator() {
        }

        @Override
        public int compare(AbstractModelEditPart o1, AbstractModelEditPart o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Rectangle bounds1 = o1.getFigure().getBounds();
            Rectangle bounds2 = o2.getFigure().getBounds();
            int rightX1 = bounds1.x + bounds1.width;
            int rightX2 = bounds2.x + bounds2.width;
            return rightX1 - rightX2;
        }
    }

    public static class HorizontalLineRetargetAction
    extends LabelRetargetAction {
        public HorizontalLineRetargetAction() {
            super(ID, ResourceString.getResourceString("action.title.horizontal.line"));
            this.setImageDescriptor(Activator.getImageDescriptor("HORIZONTAL_LINE"));
            this.setToolTipText(ResourceString.getResourceString("action.title.horizontal.line"));
        }
    }
}

