/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action.line;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.swt.widgets.Event;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.controller.command.diagram_contents.element.connection.RightAngleLineCommand;
import org.insightech.er.editor.controller.editpart.element.connection.RelationEditPart;
import org.insightech.er.editor.controller.editpart.element.node.IResizable;
import org.insightech.er.editor.controller.editpart.element.node.NodeElementEditPart;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.view.action.AbstractBaseSelectionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RightAngleLineAction
extends AbstractBaseSelectionAction {
    public static final String ID = RightAngleLineAction.class.getName();

    public RightAngleLineAction(ERDiagramEditor editor) {
        super(ID, ResourceString.getResourceString("action.title.right.angle.line"), editor);
    }

    @Override
    protected List<Command> getCommand(EditPart editPart, Event event) {
        AbstractConnectionEditPart connectionEditPart;
        ArrayList<Command> commandList = new ArrayList<Command>();
        if (editPart instanceof IResizable) {
            NodeElementEditPart nodeElementEditPart = (NodeElementEditPart)editPart;
            for (Object obj : nodeElementEditPart.getSourceConnections()) {
                AbstractConnectionEditPart connectionEditPart2 = (AbstractConnectionEditPart)obj;
                if (connectionEditPart2.getSource() == connectionEditPart2.getTarget()) continue;
                commandList.add(RightAngleLineAction.getCommand(connectionEditPart2));
            }
        } else if (editPart instanceof AbstractConnectionEditPart && (connectionEditPart = (AbstractConnectionEditPart)editPart).getSource() != connectionEditPart.getTarget()) {
            commandList.add(RightAngleLineAction.getCommand(connectionEditPart));
        }
        return commandList;
    }

    public static Command getCommand(AbstractConnectionEditPart connectionEditPart) {
        int sourceX = -1;
        int sourceY = -1;
        int targetX = -1;
        int targetY = -1;
        if (connectionEditPart instanceof RelationEditPart) {
            Rectangle bounds;
            NodeEditPart editPart;
            RelationEditPart relationEditPart = (RelationEditPart)connectionEditPart;
            Relation relation = (Relation)relationEditPart.getModel();
            if (relation.getSourceXp() != -1) {
                editPart = (NodeEditPart)relationEditPart.getSource();
                bounds = editPart.getFigure().getBounds();
                sourceX = bounds.x + bounds.width * relation.getSourceXp() / 100;
                sourceY = bounds.y + bounds.height * relation.getSourceYp() / 100;
            }
            if (relation.getTargetXp() != -1) {
                editPart = (NodeEditPart)relationEditPart.getTarget();
                bounds = editPart.getFigure().getBounds();
                targetX = bounds.x + bounds.width * relation.getTargetXp() / 100;
                targetY = bounds.y + bounds.height * relation.getTargetYp() / 100;
            }
        }
        if (sourceX == -1) {
            NodeElementEditPart sourceEditPart = (NodeElementEditPart)connectionEditPart.getSource();
            Point sourcePoint = sourceEditPart.getFigure().getBounds().getCenter();
            sourceX = sourcePoint.x;
            sourceY = sourcePoint.y;
        }
        if (targetX == -1) {
            NodeElementEditPart targetEditPart = (NodeElementEditPart)connectionEditPart.getTarget();
            Point targetPoint = targetEditPart.getFigure().getBounds().getCenter();
            targetX = targetPoint.x;
            targetY = targetPoint.y;
        }
        RightAngleLineCommand command = new RightAngleLineCommand(sourceX, sourceY, targetX, targetY, (ConnectionEditPart)connectionEditPart);
        return command;
    }

    @Override
    protected boolean calculateEnabled() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        for (Object object : viewer.getSelectedEditParts()) {
            NodeElementEditPart nodeElementEditPart;
            if (object instanceof ConnectionEditPart) {
                return true;
            }
            if (!(object instanceof NodeElementEditPart) || (nodeElementEditPart = (NodeElementEditPart)object).getSourceConnections().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

